<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
     <script>
      function myCallBack(lovwin, event)
      {
          
      }

	  

      function setPasswordChanged()
      {
        
        document.foo.pwdchange.value = "true"; 
        
      }
     </script>
    </uix:metaContainer>


    
      <uix:body>
      <db:form name="foo" method="POST" destination="/console/database/security/user" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
      <uix:formValue name="pageName" value="/database/security/users/generalPage"/>
      <!--uix:formValue name="cexpirestatus" valueBinding="cexpirestatus@objectBean@servletRequest" /-->
      <uix:formValue name="pwdchange" valueBinding="pwdchange@objectBean@servletRequest" />
      <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />

        <%@ include file="/database/global.jspf" %>
        

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="0">
              <%
				boolean areAllTabsAccesible = true;
				if(request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR") !=null) 
				{
					areAllTabsAccesible = ((Boolean)request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR")).booleanValue();
				}
				%>
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest" />
		
		<uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                   	<uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
	                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                    </uix:case>
                    <uix:case name="false">
		    <%if(areAllTabsAccesible){%>
		               	<uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
	                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
		     <%}%>		 
                    </uix:case>
                  </uix:switcher>
		
                <% if(areAllTabsAccesible){
		%>
		 <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                 <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                  <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest"
                    onClick="submitForm('foo', true, {event:'quotaTab'})"/>
                  </uix:case>
                </uix:switcher>
                  <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                    <uix:case name="true">
                    <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                    </uix:case>
                   </uix:switcher>
                   </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                 <uix:case name="false">
                    <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest"
                    onClick="submitForm('foo', true, {event:'proxyTab'})"/>
                  </uix:case>
                </uix:switcher>
		<%}%>
            </uix:subTabBar>
          </uix:subTabs>

         

            <%-- start General Information section --%>
            
            <uix:switcher childNameBinding="userPUBLIC@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:styledText textBinding="PUBLIC_USER_GRP@uixuserBundle@servletRequest" styleClass="OraDataText"/>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="false">
                 <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:messagePrompt labeledNodeId="objectName" promptBinding="NAME@uixDBObjectBundle@servletRequest" required="yes"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
     	          <uix:stackLayout>
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:textInput id="objectName" name="objectName" textBinding="objectName@objectBean@servletRequest" columns="50"/>
                    </uix:case>
                    <uix:case name="false">
                      <uix:styledText textBinding="objectName@objectBean@servletRequest" styleClass="OraDataText" />
                    </uix:case>
                  </uix:switcher>
                  <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>
                         
              <%-- Profile Information section --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="profileType" promptBinding="PROFILE@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <oem:choice id="profileType" name="profileType" optionsBinding="profileTypes@objectBean@servletRequest" selectedValueBinding="profileType@objectBean@servletRequest"/>
                </uix:cellFormat>
                </uix:rowLayout>

                <%-- Authentication Types section --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="authenticationType" promptBinding="AUTHENTICATION@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat  hAlign="left">
                  <uix:choice id="authenticationType" name="authenticationType"  onChange="submitForm('foo', true, {'event':'changeType'})" selectedValueBinding="authenticationType@objectBean@servletRequest">
                    <uix:option textBinding="PASSWORD@uixuserBundle@servletRequest"
                            value="Password" /> 
                    <uix:option textBinding="EXTERNAL@uixuserBundle@servletRequest"
                            value="External" /> 
                    <uix:option textBinding="GLOBAL@uixuserBundle@servletRequest"
                            value="Global" />
                  </uix:choice>
                </uix:cellFormat>
              </uix:rowLayout>

              <%-- Based on the authentication type show different data --%>
              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                  <uix:case name="0">
                  <uix:switcher childNameBinding="passwordverifyType@objectBean@servletRequest">
                      <uix:case name="0">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt labeledNodeId="secretOldPassword" promptBinding="ENTER_OLD_PASSWORD@uixuserBundle@servletRequest" required="no"/>
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:textInput id="secretOldPassword" name="secretOldPassword" secret="true" textBinding="secretOldPassword@objectBean@servletRequest" noAutoComplete="true" columns="50"/>
                          <uix:messageText messageBinding="secretOldPassword@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>
                      </uix:rowLayout>
                      </uix:case>
                  </uix:switcher>
                  </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                  <uix:case name="0">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="secretPassword" promptBinding="ENTER_PASSWORD@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput id="secretPassword" name="secretPassword" secret="true" textBinding="secretPassword@objectBean@servletRequest" onChange="setPasswordChanged()" noAutoComplete="true" columns="50"/>
                      <uix:messageText messageBinding="secretPassword@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="1">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    </uix:cellFormat>
                    <uix:messagePrompt promptBinding="EXTERNAL_MSG@uixuserBundle@servletRequest"/>
                  </uix:rowLayout>
                </uix:case>
                <uix:case name="2">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="dnName" promptBinding="X500NAME@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput id="dnName" name="dnName" textBinding="dnName@objectBean@servletRequest" columns="50"/>
                      <uix:messageText messageBinding="dnName@errors@servletRequest" messageType="error"/>
                      <uix:messagePrompt promptBinding="GLOBAL_MSG@uixuserBundle@servletRequest"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>

              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                <uix:case name="0">
                 
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="secretConfirmPassword" promptBinding="CONFIRM_PASSWORD@uixuserBundle@servletRequest" required="yes"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
    		      <uix:textInput id="secretConfirmPassword" name="secretConfirmPassword" secret="true" noAutoComplete="true" textBinding="secretConfirmPassword@objectBean@servletRequest" columns="50" />
                      <uix:messageText messageBinding="secretConfirmPassword@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:rowLayout>
                  </uix:case>
                 </uix:switcher>

              <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
                <uix:case name="0">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                   <uix:messagePrompt prompt=""/>
                  </uix:cellFormat>
                  <uix:messagePrompt promptBinding="PASSWORD_MSG@uixuserBundle@servletRequest"/>
                  </uix:rowLayout>
                  </uix:case>
                 </uix:switcher>

                <uix:switcher childNameBinding="editableexpired@objectBean@servletRequest">
                  <uix:case name="0">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">                   
                    <uix:messagePrompt promptBinding="PASSWORD_STATUS@uixuserBundle@servletRequest"/>
                  </uix:cellFormat>
     	            <uix:cellFormat hAlign="left">
                    <uix:styledText textBinding="expired@objectBean@servletRequest" styleClass="OraDataText"/>
                  </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:case>
                 </uix:switcher>

                 <uix:switcher childNameBinding="editableexpired@objectBean@servletRequest">
                  <uix:case name="0">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                   <!--uix:messagePrompt prompt=""/-->
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraInlineInfoText" textBinding="expiredinfo@objectBean@servletRequest"/>
                  </uix:cellFormat>
                  </uix:rowLayout >
                  </uix:case>
                 </uix:switcher>

                  <uix:switcher childNameBinding="editableexpired@objectBean@servletRequest">
                  <uix:case name="1">
                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                   <uix:messagePrompt prompt=""/>
                  </uix:cellFormat>				   
                  <uix:checkBox
                        name="expirePassword"
                        checkedBinding="expirePassword@objectBean@servletRequest"
                        textBinding="EXPIRE_PASSWORD_NOW@uixuserBundle@servletRequest" />
				  <uix:formValue name="cexpirestatus" value="true"/>                        
                  </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
               
              <%-- tablespace --%>
              <%
				boolean areAllTabsAccesible = true;
				if(request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR") !=null) 
				{
					areAllTabsAccesible = ((Boolean)request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR")).booleanValue();
				}
				if(areAllTabsAccesible){
				%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="defaultTablespace" promptBinding="DEFAULTTABLESPACE@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:stackLayout>
                      <uix:messageLovField id="defaultTablespace"
                              name="defaultTablespace" textBinding="defaultTablespace@objectBean@servletRequest"
                              shortDescBinding="SELECT_DEFAULT_TBSP_HINT@uixgranteeBundle@servletRequest"
                              searchDescBinding="SELECT_DEFAULT_TBSP_HINT@uixgranteeBundle@servletRequest"
                              onClickBinding="defaulttbslovdest@servletRequest" />

                      <uix:messageText messageBinding="defaultTablespace@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="tempTablespace" promptBinding="TEMPORARYTABLESPACE@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:stackLayout>
                      <uix:messageLovField id="tempTablespace"
                              name="tempTablespace"
                              textBinding="tempTablespace@objectBean@servletRequest"
                              shortDescBinding="SELECT_TEMP_TBSP_HINT@uixgranteeBundle@servletRequest"
                              searchDescBinding="SELECT_TEMP_TBSP_HINT@uixgranteeBundle@servletRequest"
                              onClickBinding="tmptbslovdest@servletRequest"/>
                            
                      <uix:messageText messageBinding="Tablespace@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
              </uix:rowLayout>
              <%}else{%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="defaultTablespace" promptBinding="DEFAULTTABLESPACE@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:stackLayout>
                      <uix:messageTextInput id="defaultTablespace"
                              name="defaultTablespace" textBinding="defaultTablespace@objectBean@servletRequest"
                              shortDescBinding="SELECT_DEFAULT_TBSP_HINT@uixgranteeBundle@servletRequest"
                               tip="Takes the default tablespace if left empty"/>

                      <uix:messageText messageBinding="defaultTablespace@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="tempTablespace" promptBinding="TEMPORARYTABLESPACE@uixuserBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:stackLayout>
                      <uix:messageTextInput id="tempTablespace"
                              name="tempTablespace"
                              textBinding="tempTablespace@objectBean@servletRequest"
                              shortDescBinding="SELECT_TEMP_TBSP_HINT@uixgranteeBundle@servletRequest"
                              tip="Takes the default temporary tablespace if left empty"/>
                            
                      <uix:messageText messageBinding="Tablespace@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
              </uix:rowLayout>
<%}%>
              <%-- Status of user section --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:flowLayout>
                  <oem:radioButton
                          name="status"
                          selectedValueBinding="status@objectBean@servletRequest"
                          textBinding="LOCKED@uixuserBundle@servletRequest"
                          value="LOCK" />
                  <oem:radioButton
                          name="status"
                          selectedValueBinding="status@objectBean@servletRequest"
                          textBinding="UNLOCKED@uixuserBundle@servletRequest"
                          value="UNLOCK"/>
                </uix:flowLayout>
              </uix:rowLayout>
              </uix:tableLayout>
                </uix:case>
               </uix:switcher>
                
          
          
        </uix:subTabLayout>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
	  </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
      </db:form>
      </uix:body>
   
</uix:document>
</uix:renderingContext>  

