<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELUSERS@uixuserBundle@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
    <db:form
      name="selectUserForm" 
      method="post"
      destination="/console/database/security/user" copyParams="target,type,cancelURL,oname,otype">

      <uix:pageLayout titleBinding="SELUSERS@uixuserBundle@servletRequest">

        <%@ include file="/database/global.jspf" %>

        <uix:formValue 
          name="pageName" 
          value="/database/security/users/proxySelectUser"/>

        <uix:formValue 
          name="launchtabletype" 
          valueBinding="launchtabletype@servletRequest"/>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

       

          <%-------------------------
           -  Search Filter
           ---------------------------%>
          <uix:header
            textBinding="SEARCH@uixDBObjectBundle@servletRequest">
            <uix:stackLayout>

              <%-- Use different text for different types of objects --%>
              <uix:rowLayout>
                <uix:contents>
                  <uix:styledText 
                    textBinding="ENTER_OBJECT_NAME@uixDBObjectBundle@servletRequest" styleClass="OraPrompText" />
                  <uix:cellFormat>
                    
                  </uix:cellFormat>
                </uix:contents>
              </uix:rowLayout>

              <uix:tableLayout cellSpacing="2">
                <uix:cellFormat vAlign="top">
                  <%-- Display the object name --%>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:flowLayout>
                            <uix:styledText labeledNodeId="searchFilter" 
                              textBinding="AVAILABLE_USERS@uixuserBundle@servletRequest" styleClass="OraPrompText"/>
                            <uix:textInput id="searchFilter" name="searchFilter"
                              textBinding="searchFilter@objectBean@servletRequest"/>
                            <uix:formValue name="event" value="searchUsers"/>
                            <uix:submitButton 
                              textBinding="GO@uixDBObjectBundle@servletRequest"
                              onFocus="true"
                              selected="true" name="event" value="searchUsers"/>
                          </uix:flowLayout>

                          <oem:messageBox 
                            messageType="error" 
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText"
                            mainTextKey="mainText"/>

                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>
                </uix:cellFormat>
              </uix:tableLayout>
            </uix:stackLayout>
          </uix:header>


          <uix:header 
            textBinding="AVAILABLE_USERS@uixuserBundle@servletRequest"
            >

            <oem:table 
              width="100%" 
              blockSize="10"
              formSubmitted="true"
              name="availUsersTableUI" 
              beanKey="availusersBean"
              dataSourceProp="availUsersTableUI"
              summaryBinding="AVAILABLE_USERS@uixuserBundle@servletRequest"
              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest"
              >
              <uix:tableSelection>
                <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@availusersBean@servletRequest" selectedBinding="selected"/>
                
              </uix:tableSelection>
            </oem:table>
          </uix:header>

       
        <%-------------------------
         -  Footer
         ---------------------------%>
        <uix:pageButtons>
          <uix:pageButtonBar>

            <uix:submitButton
              name="event" 
              textBinding="CANCEL@uixDBObjectBundle@servletRequest"
              value="cancelSelectUsers"/>

            <uix:submitButton
              name="event" 
              textBinding="SELECT@uixDBObjectBundle@servletRequest"
              value="finishselectUsers"/>

          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>



