<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/security/user" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
        <uix:formValue name="pageName" value="/database/security/users/proxyUsersPage"/>
        <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="6">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"
                onClick="submitForm('foo', true, {event:'generalTab'})"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                 <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest" 
                 onClick="submitForm('foo', true, {event:'quotaTab'})"/>
                <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                  <uix:case name="true">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                  </uix:case>
                </uix:switcher>
                <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest" />
                 
             
            </uix:subTabBar>
          </uix:subTabs>

          <uix:header textBinding="USERS_WHO_CAN_PROXY@uixuserBundle@servletRequest" >
         
          <uix:tableLayout width="100%"> 
            
            <uix:rowLayout hAlign="right"> 
               <uix:submitButton 
                        textBinding="ADD@uixDBObjectBundle@servletRequest"
                        name="event"
                        value="addproxy" />
                    
            </uix:rowLayout> 
          
          <uix:rowLayout>
              <%--- User Table ---%>
              <oem:table  name="proxyUsersTableUI" blockSize="10"
                formSubmitted="true"               
                dataSourceProp="proxyUsersTableUI"
                beanKey="proxyuserBean" 
                summaryBinding="USERS_WHO_CAN_PROXY@uixuserBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" >
                <uix:tableSelection>
                  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@proxyuserBean@servletRequest" selectedBinding="selected" >
                    <uix:submitButton
                      textBinding="REMOVE@uixuserBundle@servletRequest"
                      name="event"
                      value="deleteproxy"/>
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>

          <uix:header textBinding="WHO_THIS_USER_CAN_PROXY@uixuserBundle@servletRequest" >
          <uix:tableLayout width="100%">
                       
          <uix:rowLayout hAlign="right"> 
            <uix:submitButton 
                        textBinding="ADD@uixDBObjectBundle@servletRequest"
                        name="event"
                        value="addforproxy" />
                    
          </uix:rowLayout> 
          
          <uix:rowLayout>
              <%--- User Table ---%>
              <oem:table  name="proxyForUsersTableUI" blockSize="10"
                formSubmitted="true"               
                dataSourceProp="proxyForUsersTableUI"
                beanKey="proxyforuserBean" 
                summaryBinding="WHO_THIS_USER_CAN_PROXY@uixuserBundle@servletRequest"
                alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" >
                <uix:tableSelection>
                  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectionBinding="selection@proxyforuserBean@servletRequest" selectedBinding="selected" >
                    <uix:submitButton
                      textBinding="REMOVE@uixuserBundle@servletRequest"
                      name="event"
                      value="deleteforproxy"/>
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
        </uix:subTabLayout>
        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />            
	  </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
       </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 

