<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/security/user" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
        <uix:formValue name="pageName" value="/database/security/users/quotaPage"/>
        <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="4">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"
                onClick="submitForm('foo', true, {event:'generalTab'})"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                 <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest" />
                 
                <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                  <uix:case name="true">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                      onClick="submitForm('foo', true, {event:'consumerGrpTab'})"/>
                  </uix:case>
                </uix:switcher>
                <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'proxyTab'})"/>
             
            </uix:subTabBar>
          </uix:subTabs>

          <uix:switcher childNameBinding="systemUnlimitedPriv@objectBean@servletRequest">
              <uix:case name="true">
                <uix:styledText textBinding="QUOTAUNLIMITED@uixuserBundle@servletRequest" styleClass="OraDataText" />
              </uix:case>
              <uix:case name="false">
              <uix:tableLayout cellSpacing="5">
                <uix:stackLayout>
                 
                  <oem:table name="quotaTableUI" beanKey="quotaPageBean" blockSize="25"
                              destination="/console/database/security/user" formSubmitted="true"
                              summaryBinding="QUOTA_TAB@uixuserBundle@servletRequest"
                              alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" dataSourceProp="quotaTableUI" width="100%">
                    
                  </oem:table>
                  
                </uix:stackLayout>

            </uix:tableLayout>
            </uix:case>
          </uix:switcher>
  
        </uix:subTabLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />            
	  </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
       </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 

