<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>

  
  <uix:body>
  <db:form name="foo" method="post" destination="/console/database/security/user" copyParams="target,type,cancelURL,oname,otype,guid,version,initMethod">
  <uix:formValue name="pageName" value="/database/security/users/viewUserPage"/>
  <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
    <%@ include file="/database/global.jspf" %>

    <%-- Warning/Error display --%>
    <oem:messageBox messageType="info"
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="error"
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    
    <uix:header textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
       <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
      </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
      <uix:cellFormat hAlign="right">
       <uix:messagePrompt promptBinding="PROFILE@uixuserBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="profileType@objectBean@servletRequest" />
      </uix:cellFormat>
       </uix:rowLayout>
      
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="AUTHENTICATION@uixroleBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="authenticationType@objectBean@servletRequest" />
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:switcher childNameBinding="authenticationTypeID@objectBean@servletRequest">
            
        <uix:case name="2">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="X500NAME@uixuserBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="dnName@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:case>
      </uix:switcher>

       <uix:rowLayout>
       <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="DEFAULTTABLESPACE@uixuserBundle@servletRequest" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="defaultTablespace@objectBean@servletRequest" />
        </uix:cellFormat>
       </uix:rowLayout>

       <uix:rowLayout>
       <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="TEMPORARYTABLESPACE@uixuserBundle@servletRequest" />
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="tempTablespace@objectBean@servletRequest" />
      </uix:cellFormat>
       </uix:rowLayout>

       <uix:rowLayout>
       <uix:cellFormat hAlign="right">
       <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
       </uix:cellFormat>
       <uix:cellFormat hAlign="left">
       <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest" />
      </uix:cellFormat>
       </uix:rowLayout>

      <%
	boolean areAllTabsAccesible = true;
	if(request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR") !=null) 
	{
		areAllTabsAccesible = ((Boolean)request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR")).booleanValue();
	}
	if(areAllTabsAccesible){ 
	%>
	
      <uix:rowLayout>
       <uix:cellFormat hAlign="right">
         <uix:messagePrompt promptBinding="INITIALCONSGRP@uixgranteeBundle@servletRequest" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
         <uix:styledText styleClass="OraDataText" textBinding="defaultconsgrp@consumerGrpPageBean@servletRequest" />
        </uix:cellFormat>
       </uix:rowLayout>
       
       <%}%>
       
    </uix:tableLayout>
    </uix:header>
   
     <%
	boolean areAllTabsAccesible = true;
	if(request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR") !=null) 
	{
		areAllTabsAccesible = ((Boolean)request.getAttribute("ALL_TABS_ACCESSIBLE_TO_ACCTMGR")).booleanValue();
	}
	if(areAllTabsAccesible){ 
	%>

   <uix:header textBinding="ROLE_TAB@uixgranteeBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="rolesTableUI" beanKey="rolePageBean"
             blockSize="10" destinationBinding="destination@rolePageBean@servletRequest" formSubmitted="true"
             summaryBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
             dataSourceProp="rolesTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>	
    
    <uix:header textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="sysPrivsTableUI" beanKey="systemPageBean"
             blockSize="10" destinationBinding="destination@systemPageBean@servletRequest" formSubmitted="true"
             summaryBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
             dataSourceProp="sysPrivsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>

    <uix:header textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="objPrivsTableUI" beanKey="objectPageBean"
             blockSize="10" destinationBinding="destination@objectPageBean@servletRequest" formSubmitted="true"
             summaryBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
             dataSourceProp="objPrivsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>

    <uix:header textBinding="QUOTA_TAB@uixuserBundle@servletRequest">
     <uix:switcher childNameBinding="systemUnlimitedPriv@objectBean@servletRequest">
        <uix:case name="true">
           <uix:styledText textBinding="QUOTAUNLIMITED@uixuserBundle@servletRequest" styleClass="OraDataText" />
         </uix:case>
         <uix:case name="false">
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                 <oem:table name="quotaTableUI" beanKey="quotaPageBean"
                       blockSize="10" destinationBinding="destination@quotaPageBean@servletRequest" formSubmitted="true"
                        summaryBinding="QUOTA_TAB@uixuserBundle@servletRequest"
                        dataSourceProp="quotaTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
              </uix:rowLayout>
             </uix:tableLayout>
          </uix:case>
        </uix:switcher>
    </uix:header>

    
    <uix:header textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest">
     <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="consumerGrpsTableUI" beanKey="consumerGrpPageBean"
             blockSize="10" destinationBinding="destination@consumerGrpPageBean@servletRequest" formSubmitted="true"
             summaryBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
             dataSourceProp="consumerGrpsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>

    <uix:header textBinding="PROXY_TAB@uixuserBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="proxyUsersTableUI" beanKey="proxyuserBean"
             blockSize="10" destinationBinding="destination@proxyuserBean@servletRequest" formSubmitted="true"
             summaryBinding="PROXY_TAB@uixuserBundle@servletRequest"
             dataSourceProp="proxyUsersTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%" copyParams="target,type"/>
      </uix:rowLayout>
      </uix:tableLayout>
      </uix:header>

    <uix:header textBinding="PROXYFOR_TAB@uixuserBundle@servletRequest">
    <uix:tableLayout cellSpacing="5">
      <uix:rowLayout>
        <oem:table name="proxyForUsersTableUI" beanKey="proxyforuserBean"
             blockSize="10" destinationBinding="destination@proxyforuserBean@servletRequest" formSubmitted="true"
             summaryBinding="PROXYFOR_TAB@uixuserBundle@servletRequest"
             dataSourceProp="proxyForUsersTableUI" copyParams="target,type" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%"/>
      </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
 <%}%>
    <uix:pageButtons>
       <uix:pageButtonBar>
        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
         <jsp:include page="/database/storage/storagePageButtonViewInclude.jsp" />
         <uix:ref refID="storagePageButtonViewInclude" />
          </uix:case>
          <uix:case name="true">
          <%-- OK Button --%>
          <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
          </uix:case>
        </uix:switcher>
    </uix:pageButtonBar>
    </uix:pageButtons>
       
      </uix:pageLayout>
       </db:form>
      </uix:body>
   
</uix:document>
</uix:renderingContext>  

