<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.sec.AppsContextMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<db:script src="/database/LOV.js"/>

<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:bundle name="appsContextMsgs" class="oracle.sysman.db.rsc.sec.AppsContextMsg"/>
<uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.PolicyMsg"/>

<uix:document>
<%@ include file="/oemTitle.jspf"%>
<uix:metaContainer>
<uix:head titleBinding="title@servletRequest"/>
</uix:metaContainer>
<script language="JavaScript" >
<%@ include file="/database/LOV.js"%>
</script>
<uix:body>
<db:form name="appsContext" method="POST" destination="/console/database/security/vpd/appsContext" copyParams="target,type,otype,objectType">


<uix:contents>
<uix:pageLayout titleBinding="header@servletRequest" >
<%@ include file="/database/global.jspf" %>

<uix:formValue name="pageName" value="/database/security/vpd/appsContext"/>

<oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
titleTextKey="titleText" mainTextKey="mainText"/>
<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
titleTextKey="titleText" mainTextKey="mainText"/>

<uix:contents>



<uix:subTabLayout>

<uix:contents>
<uix:stackLayout>
<uix:contents>
<uix:styledText textBinding="OVERVIEW_APPSCONTEXT@appsContextMsgs"
styleClass="OraInstructionText"/>
<uix:spacer width="10" height="10"/>
<uix:header textBinding="SEARCH@dbMsgs"/>
<uix:rowLayout>
<uix:contents>
<uix:spacer width="20" height="10"/>
<uix:styledText textBinding="SEARCH_MESSAGE@appsContextMsgs"

styleClass="OraInstructionText"/>
</uix:contents>
</uix:rowLayout>
<uix:spacer width="10" height="20"/>
<uix:tableLayout width="45%" cellSpacing="5">
                                    <uix:contents>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="schemaSearchName" styleClass="OraInstructionText" textBinding="PACKAGE_SCHEMA@appsContextMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        <uix:messageLovField shortDescBinding="PACKAGE_SCHEMA@appsContextMsgs" 
														searchDescBinding="PACKAGE_SCHEMA@appsContextMsgs"
														id="schemaSearchName" name="schemaSearchName" onClick="startLov('schemaSearchName','ListSchema')" 
                                                        textBinding="schemaSearchName@appsContextList@servletRequest"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:messageStyledText labeledNodeId="packageSearchName" styleClass="OraInstructionText" textBinding="PACKAGE_NAME@appsContextMsgs"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                        
                                                    
													<uix:messageLovField shortDescBinding="PACKAGE_NAME@appsContextMsgs" 
														searchDescBinding="PACKAGE_NAME@appsContextMsgs"
														id="packageSearchName" name="packageSearchName" 
                                                        onClick="setSearchFilter('schemaSearchName');startLov('packageSearchName','ListPackageAppsContext')"
														textBinding="packageSearchName@appsContextList@servletRequest"/>
													</uix:contents>
                                                </uix:cellFormat> 
                                            </uix:contents>
                                        </uix:rowLayout>
                                         <uix:rowLayout width="100%">
					                                            <uix:contents>
					                                                <uix:cellFormat hAlign="right">
					                                                    <uix:contents>
					                                                        <uix:messageStyledText labeledNodeId="namespaceSearchName" styleClass="OraInstructionText" textBinding="NAMESPACE@appsContextMsgs"/>
					                                                    </uix:contents>
					                                                </uix:cellFormat>
					                                                <uix:cellFormat/>
					                                                <uix:cellFormat hAlign="left">
					                                                    <uix:contents>
					                                                        <uix:messageTextInput shortDescBinding="NAMESPACE@appsContextMsgs"
																		
id="namespaceSearchName" name="namespaceSearchName" textBinding="namespaceSearchName@appsContextList@servletRequest"/>
					                                                    </uix:contents>
					                                                </uix:cellFormat> 
					                                            </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%">
                                            <uix:contents>
                                                <uix:cellFormat/>
                                                <uix:cellFormat/>
                                                <uix:cellFormat hAlign="left" width="75%">
                                                    <uix:contents>
                                                        <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" onFocus="true" selected="true" name="event" value="search"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:contents>
                                </uix:tableLayout>

 




<uix:separator/>
<uix:spacer height="20" width="95"/>
<uix:rowLayout>
<uix:contents>
<uix:spacer width="20" height="10"/>
<uix:tableLayout>
<uix:contents>
<uix:rowLayout>
<uix:contents>

</uix:contents>
</uix:rowLayout>
<uix:rowLayout>
<uix:contents>
<uix:cellFormat hAlign="right" vAlign="middle" width="650">
<uix:contents>
<uix:submitButton  shortDescBinding="CREATE@dbMsgs" textBinding="CREATE@dbMsgs" name="event" value="create"/>
</uix:contents>
</uix:cellFormat>
</uix:contents>
</uix:rowLayout>
	<uix:rowLayout width="100%">
<uix:contents>
<uix:cellFormat width="90%">
<uix:contents>

<uix:dataScope currentDataBinding="appsContextList@servletRequest">					

							      <uix:table name="appsContextList" alternateTextBinding="tableAlterText" formSubmitted="true" width="100%" tableDataBinding="rowData" valueBinding="startIndex"
											maxValueBinding="numRows"  minValue="1" blockSize="10" 
											summaryBinding="APPSCONTEXT_LIST_SUMMARY@appsContextMsgs" shortDescBinding="APPSCONTEXT_LIST_SUMMARY@appsContextMsgs" >


											<uix:column>					
												<uix:columnHeader>
												<uix:sortableHeader textBinding="NAMESPACE@appsContextMsgs"  sortable="true"/>
												</uix:columnHeader>
												<uix:columnFormat columnDataFormat="textFormat" />
												<uix:link destinationBinding="viewURL" textBinding="<%= AppsContextMsgID.NAMESPACE %>" />

						</uix:column>


								     <uix:column>
											<uix:columnHeader>
											    <uix:sortableHeader textBinding="PACKAGE_SCHEMA@appsContextMsgs" sortable="no"/>
											</uix:columnHeader> 
											<uix:columnFormat columnDataFormat="textFormat" />
											<uix:text textBinding="<%= AppsContextMsgID.PACKAGE_SCHEMA %>"/>
											</uix:column>

											<uix:column>
											<uix:columnHeader>
											    <uix:sortableHeader textBinding="PACKAGE_NAME@appsContextMsgs" sortable="no"/>
											</uix:columnHeader> 
											<uix:columnFormat columnDataFormat="textFormat"/>
											<uix:text textBinding="<%= AppsContextMsgID.PACKAGE_NAME %>"/>
											</uix:column>

											<uix:column>
											<uix:columnHeader>
											    <uix:sortableHeader textBinding="ACCESS_METHOD@appsContextMsgs" sortable="no"/>
											</uix:columnHeader> 
											<uix:columnFormat columnDataFormat="textFormat" />
											<uix:text textBinding="<%= AppsContextMsgID.ACCESS_METHOD %>"/>
											</uix:column>





											<uix:tableSelection>
											    <uix:singleSelection 
shortDescBinding="APPLICATION_CONTEXTS@appsContextMsgs" selectedIndex="0">

												<uix:contents>
												    <uix:submitButton textBinding="CREATE_LIKE@dbMsgs" shortDescBinding="CREATE_LIKE@dbMsgs" name="event"
													value="createLike" />
												     <uix:spacer width="10" height="10"/>
													<uix:submitButton textBinding="VIEW@dbMsgs" shortDescBinding="VIEW@dbMsgs" name="event" value="view"/>

												     <uix:spacer width="10" height="10"/>
													<uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="delete"/>



												</uix:contents> 
											    </uix:singleSelection>
											</uix:tableSelection>	

											</uix:table>
			</uix:dataScope>
</uix:contents>
</uix:cellFormat>
</uix:contents>
</uix:rowLayout>

</uix:contents>
</uix:tableLayout>
</uix:contents>
</uix:rowLayout>
<uix:spacer height="20" width="95"/>

 <uix:header renderedBinding="isOID@appsContextList@servletRequest" textBinding="RELATED_LINKS@appsContextMsgs"/>
   <uix:spacer width="10" height="10"/> 
   
 <uix:switcher childNameBinding="isOID@appsContextList@servletRequest">
                        <uix:case name="true"> 
 
                              
<uix:rowLayout>
                                  <uix:contents>
								 
                                    <uix:spacer width="20" height="10"/>
                                    <uix:link textBinding="EDS@appsContextMsgs"
                                          destinationBinding="entSecURL@servletRequest"/>
                                  </uix:contents>
                                </uix:rowLayout>
								
								</uix:case>
                      </uix:switcher> 
					  
</uix:contents>
</uix:stackLayout>
</uix:contents>
</uix:subTabLayout>
</uix:contents>




</uix:pageLayout>
</uix:contents>
</db:form>
</uix:body>


</uix:document>
</uix:renderingContext>
