<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.sec.PolicyMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.PolicyMsg"/>
  <uix:document>
  <%@ include file="/oemTitle.jspf"%>
    <uix:metaContainer>
      <uix:head titleBinding="title@servletRequest" />
  
      <script language="JavaScript">
      	<%@ include file="/database/utils.js"%>
      </script>
     
    </uix:metaContainer>
    <uix:body>
              <uix:contents>
                          <db:form name="managePolicyGroup" method="POST"
                                   destination="/console/database/security/vpd/policyGroup"
                                   copyParams="target,type,otype,objectType">
                                   <uix:formValue name="pageName" value="/database/security/vpd/managePolicyGroup"/>	
                            <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
                                <uix:contents>
                               <uix:pageLayout titleBinding="header@servletRequest">
                                <%@ include file="/database/global.jspf" %>
				  <uix:messages>
    					<uix:flowLayout>
	    					<uix:contents>
		   <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
	    					 </uix:contents>
     					</uix:flowLayout>
   				</uix:messages>
                                  
                                    <uix:contents>
                                      <uix:tableLayout>
                                        <uix:contents>
                                          <uix:rowLayout>
                                            <uix:contents>
                                              <uix:stackLayout>
                                                <uix:contents>
                                                  <uix:spacer width="10"
                                                              height="20"/>
                                                  <uix:rowLayout>
                                                    <uix:contents>
                                                      <uix:spacer width="24"
                                                                  height="10"/>
                                                      <uix:messageStyledText promptBinding="POLICY_GROUP_NAME@policyMsgs"
                                                                             textBinding="policyGroupName@managePolicyList@servletRequest"
                                                                             styleClass="OraDataText"/>
                                                    </uix:contents>
                                                  </uix:rowLayout>
                                                  <uix:spacer width="10"
                                                              height="10"/>
                                                  <uix:rowLayout>
                                                    <uix:contents>
                                                      <uix:spacer width="60"
                                                                  height="9"/>
                                                       <uix:messageStyledText textBinding="objectSchemaName@managePolicyList@servletRequest" 
	                                                                promptBinding="OBJECT_NAME@policyMsgs"
	                                                                 styleClass="OraDataText"/>
                                                    </uix:contents>
                                                  </uix:rowLayout>
                                                  <uix:spacer width="10"
                                                              height="20"/>
                                                </uix:contents>
                                              </uix:stackLayout>
                                            </uix:contents>
                                          </uix:rowLayout>
                                          <uix:rowLayout>
                                            <uix:contents>
                                              <uix:stackLayout>
                                                <uix:contents>
                                                  <uix:header textBinding="MANAGE_GROUP_POLICIES@policyMsgs"/>
                                                  <uix:rowLayout width="980">
                                                    <uix:contents>
                                                      <uix:cellFormat
                                                                      width="500">
                                                        <uix:contents>
                                                          <uix:stackLayout>
                                                            <uix:contents>
                                                              <uix:rowLayout
                                                                             width="500">
                                                                <uix:contents>
                                                                  <uix:spacer width="10"
                                                                              height="10"/>
                                                                  <uix:styledText
																  textBinding="INFO_MANAGE_POLICIES@policyMsgs"
                                                                                  styleClass="OraInstructionText"/>
                                                                </uix:contents>
                                                              </uix:rowLayout>
                                                              <uix:spacer width="10"
                                                                          height="20"/>
                                                              <uix:rowLayout>
                                                                <uix:contents>
                                                                  <uix:spacer width="20"
                                                                              height="10"/>
                                                                </uix:contents>
                                                              </uix:rowLayout>
                                                              <uix:rowLayout
                                                                             width="500">
                                                                <uix:contents>
                                                                  <uix:spacer width="105"
                                                                              height="10"/>
                                                                  <uix:submitButton textBinding="ADD@dbMsgs" shortDescBinding="ADD@dbMsgs" name="event"
										
value="addPolicyFromManage" />
                                                                </uix:contents>
                                                              </uix:rowLayout>
                                                              <uix:rowLayout
                                                                             hAlign="left"
                                                                             width="400">
                                                                <uix:contents>
                                                                  <uix:spacer width="20"
                                                                              height="10"/>
                                                               
                                                                      <uix:dataScope currentDataBinding="managePolicyList@servletRequest">
<uix:table name="managePolicyList" 
alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
summaryBinding="MANAGE_GROUP_POLICIES@policyMsgs"
formSubmitted="true" 
width="100%"
tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
minValue="1"
valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>" >


<uix:tableFormat tableBanding="rowBanding"/>
<uix:column>
<uix:columnHeader>
<uix:sortableHeader textBinding="POLICY_NAME@policyMsgs" sortable="no"/>
</uix:columnHeader> 
<uix:columnFormat columnDataFormat="textFormat" width="80%"/>
<uix:text textBinding="<%= PolicyMsgID.POLICY_NAME %>" />
</uix:column>

<uix:column>
									<uix:columnHeader>
									    <uix:sortableHeader textBinding="ENABLED@policyMsgs" sortable="no"/>
									</uix:columnHeader> 
									<uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
									<uix:image sourceBinding="enabledIconDest"/>
									</uix:column>
									<uix:tableSelection>
									    <uix:singleSelection shortDescBinding="MANAGE_GROUP_POLICIES@policyMsgs"
										selectedIndex="0">
										<uix:contents>
										    
											<uix:submitButton textBinding="DELETE@dbMsgs"
											shortDescBinding="DELETE@dbMsgs" name="event" value="removePolicyManage"/>
										   
										   
										
										</uix:contents>
									    </uix:singleSelection>
									</uix:tableSelection>

</uix:table>
</uix:dataScope>
  
                                                                </uix:contents>
                                                              </uix:rowLayout>
                                                            </uix:contents>
                                                          </uix:stackLayout>
                                                          <uix:spacer width="10"
                                                                      height="100"/>
                                                        </uix:contents>
                                                      </uix:cellFormat>
                                                    </uix:contents>
                                                  </uix:rowLayout>
                                                </uix:contents>
                                              </uix:stackLayout>
                                            </uix:contents>
                                          </uix:rowLayout>
                                        </uix:contents>
                                      </uix:tableLayout>
                                    </uix:contents>
                                    <uix:pageButtons>
                                      <uix:pageButtonBar>
                                        <uix:contents>
	                              <uix:submitButton shortDescBinding="SHOWSQL@dbMsgs" textBinding="SHOWSQL@dbMsgs"
								  name="event" value="showSql"/>
	                         <uix:submitButton shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" name="event" value="cancel"/> 
							
	                              <uix:submitButton shortDescBinding="OK@dbMsgs" textBinding="OK@dbMsgs" name="event" value="apply"/>
	                           </uix:contents>
                                      </uix:pageButtonBar>
                                    </uix:pageButtons>
                                    <uix:pageStatus>
                                      <uix:flowLayout>
                                        <uix:contents>
                                          <uix:formattedText textBinding="MANAGE_POL_LIST@policyMsgs"
                                                             styleClass="OraInstructionText"/>
                                        </uix:contents>
                                      </uix:flowLayout>
                                    </uix:pageStatus>
                                  </uix:pageLayout>
                            </uix:contents>
                          </db:form>
                        </uix:contents>
                      </uix:body>
                  </uix:document>
                </uix:renderingContext>
