<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.db.rsc.sec.PolicyMsgID" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/> 
    <db:script src="/database/LOV.js"/>
  
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="appsContextMsgs" class="oracle.sysman.db.rsc.sec.AppsContextMsg"/>
<uix:bundle name="policyMsgs" class="oracle.sysman.db.rsc.sec.PolicyMsg"/>

  <uix:document>
  <%@ include file="/oemTitle.jspf"%>
    <uix:metaContainer>
    <uix:head titleBinding="title@servletRequest"/>
    </uix:metaContainer>
	<script language="JavaScript" >
        <%@ include file="/database/LOV.js"%>
        </script>
	      <uix:body>
	                <uix:contents>
	             
			   
			    <db:form name="columnsList" method="post" 
            destination="/console/database/security/vpd/policyGroup"
            copyParams="target,type, oname,otype,objectType, ">
      <uix:pageLayout titleBinding="header@servletRequest" >
	    <%@ include file="/database/global.jspf" %>  
        <uix:formValue name="pageName" value="/database/security/vpd/columnsList"/>
<uix:formValue name="backPage" valueBinding="backPage@servletRequest"/>
		 <uix:formValue name="cancelURL" valueBinding="cancelURL@servletRequest"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        	<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="2" width="80%">
         <uix:dataScope currentDataBinding="columnsList@servletRequest">
            <%-- Search Criteria and Instruction 
            <uix:rowLayout>
	            <uix:stackLayout>
	             
	               <uix:tableLayout>
	                <uix:rowLayout>
	                <uix:cellFormat>
	                  <uix:messageStyledText labeledNodeId="objectSchemaName" styleClass="OraInstructionText"
					  text="Object Name"
					  />
	                </uix:cellFormat>
	                <uix:cellFormat>
	                  <uix:spacer height="10" width="3"/>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                  <uix:messageTextInput id="objectSchemaName" name="objectSchemaName" 
                                     shortDescBinding="NAME@dbMsgs" tip="Example: Schema Name.Object Name"
                                     textBinding="objectSchemaName"/>
	                </uix:cellFormat>
					 <uix:cellFormat>
	                  <uix:spacer height="10" width="12"/>
	                </uix:cellFormat>
					<uix:cellFormat>
	                <uix:submitButton shortDescBinding="GO@dbMsgs" textBinding="GO@dbMsgs" name="event" 
                                            value="listColumns"/>
	                </uix:cellFormat>
	                </uix:rowLayout>
	                <uix:rowLayout>
	                
	                <uix:cellFormat>
	                </uix:cellFormat>
	                <uix:cellFormat>
	                </uix:cellFormat>
	                </uix:rowLayout>
	               </uix:tableLayout>
	             
	            </uix:stackLayout>
	        </uix:rowLayout> --%>
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <uix:table name="columnsList" 
                                                alternateTextBinding="usersAlterText"
                                                formSubmitted="true"
                                                width="100%"
                                                tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                                minValue="1"
                                                valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                                blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                                maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>">
                                                <uix:tableFormat tableBanding="rowBanding"/>
                                                <uix:column>
                                                <uix:columnHeader>
                                                    <uix:sortableHeader textBinding="NAME@dbMsgs" sortable="no"/>
                                                </uix:columnHeader> 
                                                <uix:columnFormat columnDataFormat="textFormat" />
                                                <uix:text textBinding="<%= DBObjectMsgID.NAME %>" />
                                                </uix:column>
                                                <uix:tableSelection>
                                                <uix:multipleSelection >
                                                </uix:multipleSelection>
                                            </uix:tableSelection>
                                                </uix:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        </uix:dataScope>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button shortDescBinding="CANCEL@dbMsgs" textBinding="CANCEL@dbMsgs" destinationBinding="cancelURL@servletRequest" />
            <uix:submitButton shortDescBinding="SELECT@dbMsgs" textBinding="SELECT@dbMsgs" name="event" value="addColumnSelected" />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
	    	                     
	    	                     </uix:contents>
	    	                   </uix:body>
	    	                 </uix:document>
	          </uix:renderingContext>
