<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_TABLESPACE@uixDBObjectBundle@servletRequest"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      
      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('tablespaceDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Tablespace', selectedIndex);
            lovField.value = selectedElement.value;
            window.close();
          }
        }
      </script>

    </uix:metaContainer>
    <uix:body>
    <db:form
      name="foo" 
      method="post"
      destinationBinding="destination@selectTablespaceBean@servletRequest" 
      copyParams="target,type,sname,oname,cancelURL">
      
      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_TABLESPACE@uixDBObjectBundle@servletRequest">
        <uix:formValue 
        name="pageName" 
        value="/database/selectTablespace"/>

       <uix:formValue name="event" value="changeTablespaceSearchCriteria" />
       

          <uix:tableLayout width="100%">
            
	        <uix:rowLayout>
	         
              <uix:cellFormat>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
	                <uix:styledText textBinding="TO_FIND_ITEM@uixDBObjectBundle@servletReqeust" styleClass="OraPromptText"/>
	                <uix:rowLayout>
	                  <uix:messagePrompt labeledNodeId="tablespaceSearchCriteria" promptBinding="SEARCH_FOR_TABLESPACE@uixDBObjectBundle@servletRequest"/>
	                  <uix:spacer width="10"/>
	                  <uix:textInput id="tablespaceSearchCriteria" name="tablespaceSearchCriteria" textBinding="tablespaceSearchCriteria@selectTablespaceBean@servletRequest"/>
	                  <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="changeTablespaceSearchCriteria"/>
	                </uix:rowLayout>
	              </uix:header>
	            </uix:stackLayout>
	          </uix:cellFormat>
	        </uix:rowLayout>
	        <uix:rowLayout>
	         
              <uix:cellFormat>
                <uix:stackLayout>
	              <uix:header textBinding="RESULTS@uixDBObjectBundle@servletRequest">
                   <oem:table name="tablespaceDataSource" beanKey="selectTablespaceBean" blockSize="10"
                        destinationBinding="destination@selectTablespaceBean@servletRequest" formSubmitted="true"
                        dataSourceProp="tablespaceDataSource" width="100%"
                  		alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                      <uix:tableSelection>
                        <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedIndex="0"/>
                      </uix:tableSelection>

                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
	          </uix:cellFormat>
	        </uix:rowLayout>
	      </uix:tableLayout>
       
	    <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" destinationBinding="selectTablespaceDestination@servletRequest" />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
      </db:form>
     </uix:body>
   

  </uix:document>
</uix:renderingContext>
