<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_VALUE@uixDBObjectBundle@servletRequest"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>      
       <script language="JavaScript" >
         <%@ include file="/cabo/jsLibs/TableProxy.js" %>
       </script>
      <script>
      function lovSelect(lovField)
      {
        var proxy = new TableProxy('valueDataSource');
        var selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
          var selectedElement = proxy.getFormElement('Value', selectedIndex);
          lovField.value = selectedElement.value;
          window.close();
        }
      }
      </script>
    </uix:metaContainer>
    <uix:body>
    <db:form name="foo" 
             method="post"
             destinationBinding="destination@selectValueBean@servletRequest"
             copyParams="target,type,sname,oname,cancelURL">
    <uix:formValue name="pageName" value="/database/selectValue"/>
      <uix:pageLayout titleBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest">
       
        <uix:styledText textBinding="SELECT_VALUE_FROM_LIST@uixDBObjectBundle@servletRequest" styleClass="OraPromptText"/>
          <uix:tableLayout cellSpacing="2">
           
                <uix:stackLayout>
                  <uix:header textBinding="VALUES@uixDBObjectBundle@servletRequest">
                  <oem:table name="valueDataSource" beanKey="selectValueBean" blockSize="10"
                      destinationBinding="destination@selectValueBean@servletRequest" formSubmitted="true"
                      dataSourceProp="valueDataSource" width="90%"
		      summaryBinding="VALUES@uixDBObjectBundle@servletRequest"
                      alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                    <uix:tableSelection>
                      <uix:singleSelection  selectedIndex="0" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"/>
                    </uix:tableSelection>
                  </oem:table>
	              </uix:header>
	            </uix:stackLayout>
              
            
          </uix:tableLayout>
	 
        <uix:pageButtons>
          <uix:pageButtonBar>
            
          <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" destination="javascript:self.close()"/>
	        <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" destinationBinding="selectValueDestination@servletRequest"/> 
	       </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
      </db:form>
     </uix:body>
   

  </uix:document>
</uix:renderingContext>
