<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundles --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="OEM_SHOW_SQL@dbMsgs"/>
</uix:metaContainer>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:body>

<%-- HTML Form --%>
<uix:form name="foo" method="post" destinationBinding="backURL@servletRequest">
<uix:pageLayout titleBinding="SHOWSQL@dbMsgs">
  <uix:formValue name="id" valueBinding="id@servletRequest"/>

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

    <%-- START: TAB CONTENTS starts here --%>
      <uix:stackLayout>
        <% 
          if (request.getAttribute("mainEmoBean") == null) {
        %> 
          <db:sqlDisplay  sqlListBinding="sqlList@servletRequest"/>
        <% } else { %>
          <db:sqlDisplay  sqlListBinding="sqlList@mainEmoBean@servletRequest"/> 
        <% } %>
      </uix:stackLayout>

    <%-- END: TAB CONTENTS ends here --%>   

  <%-- Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
     <% 
        if (request.getAttribute("mainEmoBean") != null) {
      %> 
     <uix:submitButton 
        name="launchExecuteSQL" 
        value="clicked" 
        textBinding="LAUNCH_EXECUTE_SQL@dbMsgs"
        shortDescBinding="LAUNCH_EXECUTE_SQL@dbMsgs"
        renderedBinding="launchExecuteSQLRendered@mainEmoBean@servletRequest"/>
     <%
        }
     %>   
     <uix:submitButton name="ok" 
        textBinding="RETURN@dbMsgs" 
        shortDescBinding="RETURN@dbMsgs" 
        destinationBinding="backURL@servletRequest"/>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</uix:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




