<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="dependForm" method="post" destinationBinding="destination@objectBean@servletRequest" copyParams="target,type,cancelURL,oname,otype,sname">

          <uix:formValue name="pageName" value="/database/showdep/showDependencies"/>

          <uix:pageLayout titleBinding="header@objectBean@servletRequest">
            <%@ include file="/database/global.jspf" %>

            <oem:messageBox
                messageType="info" errorTableBinding="info@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox
                messageType="error" errorTableBinding="errors@servletRequest"
                titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndex="0">
                  <uix:link textBinding="SHOWDEP_DEPENDENCIES_TAB@uixDBObjectBundle@servletRequest"/>
                  <uix:link textBinding="SHOWDEP_DEPENDENTS_TAB@uixDBObjectBundle@servletRequest"
                        onClick="submitForm('dependForm', true, {event:'dependentsTab'})"/>
                </uix:subTabBar>
              </uix:subTabs>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="instructionText@objectBean@servletRequest"/>
              <oem:table
                  name="dependenciesTable" 
                  dataSourceProp="dependenciesTable"
                  beanKey="objectBean"
                  width="100%" 
                  blockSize="20"
		  summaryBinding="SHOWDEP_DEPENDENCIES_TAB@uixDBObjectBundle@servletRequest"
                  formSubmitted="true"/>
            </uix:subTabLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    textBinding="OK@uixDBObjectBundle@servletRequest" 
                    name="event" 
                    value="showdepOK"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>
	  </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

