<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        growthTrendChart.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to show object growth trend
  --
  --  MODIFIED    (MM/DD/YY)
  --   hsu        07/25/03 - change global
  --   mnihalan   06/26/03 - mnihalan_shrinkad5_030626
  --   mnihalan   06/12/03 - Initial creation
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/growthTrendChart"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:submitButton name="event"
                                 value="<%= JspConstants.SHOW_GROWTH_TREND_OK %>" 
                                 textBinding ="OK@sdkMsgs" />

            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
              <jsp:include page="/database/schema/utilities/objectGrowthTrendChart.jsp" />  
              <uix:ref refID="objectGrowthTrendChartInclude" />
          </uix:contents>

          
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
