<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        scopeLaunchDirect.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Scope page if launched from tablespace or Schema objects
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   01/21/04 - Fix cache manager 
  --   mnihalan   01/08/04 - Change to db form 
  --   mnihalan   09/30/03 - Add advisor privs 
  --   hsu        07/25/03 - change global
  --   mnihalan   07/30/03 - Add hint text
  --   mnihalan   06/18/03 - Add browser title
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/10/03 - Initial Creation
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.ShrinkAdvPages" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
        <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
          
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,sname,oname,otype,cancelURL">
      <uix:formValue name="pageName" value="/database/shrinkAdv/scopeLaunchDirect"/>
        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
           <%@ include file="/database/global.jspf" %>

          <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@sdkMsgs" 
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                renderedBinding="hasAdvisorPrivs@defaultBean@servletRequest"
                                name="event"
                                value="<%= JspConstants.LAUNCH_DIRECT %>" />
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          
          <uix:contents>
              <uix:spacer width="10" height="3"/>
              <uix:rowLayout>

                <%--               --%>
                <%-- Radio buttons --%>
                <%--               --%>
               <uix:cellFormat width="65%" vAlign="top">
                
                       <uix:stackLayout>
                             <uix:rowLayout>
                                    <uix:spacer width="15" height="1"/>
                                    <uix:stackLayout>
                                     
                                       <uix:radioButton
                                              textBinding="ADVISOR_PARAMETER_DETAILED@stgMsg"
                                              name="advisorParameter"      
                                              selectedValueBinding="advisorParameter@defaultBean@servletRequest"
                                              value="<%= JspConstants.ADVISOR_DETAILED %>"/>
                                        <uix:rowLayout>
                                            <uix:spacer width="20"/>
                                            <uix:styledText textBinding="ADVISOR_PARAMETER_DETAILED_HINT2@stgMsg"
                                                                        styleClass="OraInlineInfoText"/>
                                        </uix:rowLayout>
                                        <uix:radioButton
                                              textBinding="ADVISOR_PARAMETER_BRIEF@stgMsg"
                                              name="advisorParameter"      
                                              selectedValueBinding="advisorParameter@defaultBean@servletRequest"
                                              value="<%= JspConstants.ADVISOR_BRIEF %>"/>
                                        <uix:rowLayout>
                                            <uix:spacer width="20"/>
                                            <uix:styledText textBinding="ADVISOR_PARAMETER_BRIEF_HINT2@stgMsg"
                                                                        styleClass="OraInlineInfoText"/>
                                        </uix:rowLayout>
                                   </uix:stackLayout>
                              </uix:rowLayout>
                        
                       </uix:stackLayout>
                </uix:cellFormat>
                <uix:spacer width="10"/>

                <%--              --%>
                <%-- Overview box --%>
                <%--              --%>
                <uix:cellFormat width="50%" vAlign="top">
                  <uix:contentContainer textBinding="SCOPE_OVERVIEW@stgMsg" width="100%">
                    <uix:stackLayout>
                      <uix:separator>
                        <uix:spacer width="10" height="7"/>
                      </uix:separator>
                      <uix:contents>
                        <uix:styledText textBinding="SCOPE_OVERVIEW_P1@stgMsg"
                                        styleClass="OraInstructionText"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contentContainer>
                </uix:cellFormat>
              </uix:rowLayout>
       
        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
