<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        showShrinkSql.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to show shrink SQL
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   06/23/04 - Change button 
  --   mnihalan   08/21/03 - Add oemTop 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Add browser title
  --   mnihalan   05/23/03 - Fix bugs
  --   mnihalan   05/19/03 - mnihalan_srhink_adv_030416
  --   mnihalan   05/15/03 - Initial creation
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shwoShrinkSql"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:submitButton name="event"
                                 value="<%= JspConstants.SHOW_SHRINK_SQL_OK %>" 
                                 textBinding ="RETURN@stgMsg" />

            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
             <%-- START: TAB CONTENTS starts here --%>
              <uix:stackLayout>
                    <db:sqlDisplay  sqlListBinding="shrinkSQL@shrinkSqlBean@servletRequest"/>
              </uix:stackLayout>
                     
          </uix:contents>

          
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
