<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvRecommendations.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/29/05 - UI review changes 
  --   mnihalan   03/29/05 - Minor UI changes 
  --   mnihalan   03/16/05 - Fix related links 
  --   mnihalan   02/28/05 - Change in workflow 
  --   mnihalan   07/20/04 - Change subtabs 
  --   mnihalan   07/08/04 - Add tabs 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/25/04 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvAllRecommendations"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
           <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                          <uix:cellFormat vAlign="top" width="45%">
                              <uix:labeledFieldLayout labelWidth="10%">
                                  <uix:contents>
                                      <uix:messagePrompt
                                            promptBinding="VIEW_SEGMENTS@stgMsg"/>
                                       <uix:switcher childNameBinding="viewTask@defaultBean@servletRequest">
                                          <uix:case name="auto" >
                                            <uix:styledText
                                                styleClass="OraDataText"
                                                textBinding="RECOMMENDATIONS_LAST_RUN@stgMsg"/>
                                          </uix:case>
                                          <uix:default>
                                             <uix:styledText
                                                styleClass="OraDataText"
                                                textBinding="ALL_RECOMMENDATIONS_VIEW@stgMsg"/>
                                          </uix:default>
                                       </uix:switcher>     
                                    </uix:contents>            
                                </uix:labeledFieldLayout> 
                              </uix:cellFormat>
                              <uix:cellFormat vAlign="top" width="40%">
                               <uix:switcher childNameBinding="viewTask@defaultBean@servletRequest">
                                 <uix:case name="auto" >
                                   <uix:labeledFieldLayout labelWidth="30%">
                                        <uix:contents>
                                                  
                                              <uix:messagePrompt
                                                        promptBinding="LAST_RUN_TIME@stgMsg"/>
                                              <uix:styledText
                                                        styleClass="OraDataText"
                                                        textBinding="lastRunDate@defaultBean@servletRequest"/>
                                              
                                  
                                        </uix:contents>            
                                    </uix:labeledFieldLayout>     
                                 </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                               <uix:cellFormat vAlign="top" width="15%">
                               <uix:switcher childNameBinding="viewTask@defaultBean@servletRequest">
                                 <uix:case name="auto" >
                                   <uix:labeledFieldLayout labelWidth="15%">
                                        <uix:contents>
                                           
                                              <uix:messagePrompt
                                                        promptBinding="LAST_RUN_STATUS@stgMsg"/>
                                              <uix:styledText
                                                        styleClass="OraDataText"
                                                        textBinding="lastRunStatus@defaultBean@servletRequest"/>
                      
                                        </uix:contents>            
                                    </uix:labeledFieldLayout>     
                                 </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout> 
          <uix:separator/>
        
          
           <uix:contents>
              <uix:stackLayout>
  
                <uix:contents>      
                      <uix:styledText textBinding="recommendationInfo@defaultBean@servletRequest"
                        styleClass="OraInstructionText"/>
                      <%-- Search Section for recommendations --%>
                      <%@ include file="shrinkAdvRecomSearch.jsp" %> 
            
                      <%--                       --%>
                      <%-- recommendations table --%>
                      <%--                       --%>
                      <uix:dataScope currentDataBinding="recommendationsBean@servletRequest">
                            <jsp:include page="shrinkAdvRecommendationsTable.jsp" />                
                                  <uix:ref refID="shrinkAdvTable" />
                      </uix:dataScope>
                      
                      <%@ include file="relatedLinks.jsp" %>
                </uix:contents>
              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
