<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvRecommendations.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      07/28/06 - Fix last run 
  --   ychan      05/18/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   03/29/05 - Add last job run time 
  --   mnihalan   03/29/05 - Minor UI changes 
  --   mnihalan   03/28/05 - Add a view drop down 
  --   mnihalan   03/16/05 - Fix related links 
  --   mnihalan   02/28/05 - Change in workflow 
  --   mnihalan   08/17/04 - Change layout 
  --   mnihalan   07/20/04 - Change subtabs 
  --   mnihalan   07/13/04 - mnihalan_seg_adv20
  --   mnihalan   07/08/04 - Add tabs 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/25/04 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="AutoTaskMsg"
            class="oracle.sysman.db.rsc.inst.AutoTaskMsg"/>            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvAllRecommendationsTblspc"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

           <uix:pageStatus>
                  <uix:styledText textBinding="recommendationTbInfo@defaultBean@servletRequest"
                        styleClass="OraInstructionText"/>
          </uix:pageStatus>
          
        
           <uix:contents>
              <uix:stackLayout>
  
                <uix:contents>      
                        <uix:tableLayout cellSpacing="5">
                              <uix:rowLayout>
                                <uix:cellFormat vAlign="top" width="40%">
                                  <uix:messagePrompt promptBinding="VIEW_SEGMENTS@stgMsg" labeledNodeId="viewTask"/> 
                                      <uix:choice
                                                  id="viewTask"
                                                  name="viewTask"
                                                  onChange='<%="submitForm(\'foo\', true, {\'event\':\'viewRuns\'})" %>'
                                                  selectedValueBinding="viewTask@defaultBean@servletRequest">
                                            
                                            <uix:contents>
                                                <uix:option textBinding="ALL_RECOMMENDATIONS_VIEW@stgMsg" value="<%= JspConstants.ALL_RUNS %>"/>
                                                <uix:option textBinding="RECOMMENDATIONS_LAST_RUN@stgMsg" value="<%= JspConstants.AUTO_RUNS %>"/>
                                            </uix:contents>
                                      </uix:choice>
                              </uix:cellFormat>
                              <uix:cellFormat vAlign="top" width="40%">
                               <uix:switcher childNameBinding="viewTask@defaultBean@servletRequest">
                                 <uix:case name="auto" >
                                   <uix:labeledFieldLayout labelWidth="30%">
                                        <uix:contents>
                                                  
                                              <uix:messagePrompt
                                                        promptBinding="LAST_RUN_TIME@stgMsg"/>
                                              <uix:styledText
                                                        styleClass="OraDataText"
                                                        textBinding="lastRunDate@defaultBean@servletRequest"/>
                                              
                                  
                                        </uix:contents>            
                                    </uix:labeledFieldLayout>     
                                 </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                               <uix:cellFormat vAlign="top" width="20%">
                               <uix:switcher childNameBinding="viewTask@defaultBean@servletRequest">
                                 <uix:case name="auto" >
                                   <uix:labeledFieldLayout labelWidth="15%" renderedBinding="showLastRunStatus@defaultBean@servletRequest">
                                        <uix:contents>
                                           
                                              <uix:messagePrompt
                                                        promptBinding="LAST_RUN_STATUS@stgMsg"/>
                                              <uix:styledText
                                                        styleClass="OraDataText"
                                                        textBinding="lastRunStatus@defaultBean@servletRequest"/>
                      
                                        </uix:contents>            
                                    </uix:labeledFieldLayout>     
                                 </uix:case>
                               </uix:switcher>
                              </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout> 
                        
                        
                        <%-- Tablespace total table --%>
                        <uix:dataScope currentDataBinding="shrinkAdvTablespaceTotalsBean@servletRequest">
                              <jsp:include page="shrinkAdvTablespaceTotalTable.jsp" />                
                                  <uix:ref refID="shrinkAdvTablespace" />
                        </uix:dataScope>
                        
                          <uix:header textBinding="RELATED_LINKS@stgMsg">
                              <uix:tableLayout width="100%"> 
                                      <uix:rowLayout vAlign="top">
                                              <uix:cellFormat vAlign="top" width="50%">
                                                  <uix:stackLayout>
                                                          <db:link textBinding="ADVISOR_CENTRAL@stgMsg" 
                                                                    renderedBinding="notLaunchedAdvisorCentral@defaultBean@servletRequest"
                                                                    destination="/console/database/instance/advisorTasks?event=doLoad" copyParams="target,type,launchedAdvisorCentral"/>
                                                          <db:link textBinding="MANUAL_SEG_ADVISOR@stgMsg" 
                                                                    destination="/console/database/shrinkAdv/shrinkAdv?event=start" copyParams="target,type"/>
                                                          <db:link textBinding="JOB_SCHEDULER@stgMsg" 
                                                                    destination="/console/database/instance/schr/jobs?pageName=history&sname=SYS&oname=GATHER_STATS_JOB" copyParams="target,type"/>
                                                  </uix:stackLayout>
                                              </uix:cellFormat>
                                              <uix:cellFormat vAlign="top" width="50%">
                                                  <uix:stackLayout>
                                                      <uix:switcher childNameBinding ="ifVersion11OrHigher@defaultBean@servletRequest" >
                                                        <uix:case name="true" >
                                                          <db:link textBinding="AUTOTASK@AutoTaskMsg" 
                                                                   destination="/console/database/instance/autoTask?event=doLoad" copyParams="target,type,pageName"/>
                                                        </uix:case>
                                                        <uix:default >
                                                          <db:link textBinding="PREDEFINED_JOB_CONFIG@stgMsg" 
                                                                      destination="/console/database/shrinkAdv/shrinkAdv?event=showConfigDetails" copyParams="target,type"/>
                                                        </uix:default>
                                                      </uix:switcher> 
                                                      <db:link textBinding="CHAINED_ROW_ANALYSIS@stgMsg" 
                                                               destination="/console/database/shrinkAdv/shrinkAdv?event=showChainedRows" copyParams="target,type"/>
                                                  </uix:stackLayout>
                                              </uix:cellFormat>
                                                       
                                      </uix:rowLayout>
                                </uix:tableLayout>
                    </uix:header>
                </uix:contents>
              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
