<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvRecommendations.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/04/05 - Fix compile exception 
  --   mnihalan   04/01/05 - Check for SYS privs 
  --   mnihalan   03/23/05 - Change the details link 
  --   mnihalan   09/02/04 - Change seg processed to details 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/26/04 - Changes for R2 
  --   mnihalan   04/27/04 - Remove mode 
  --   mnihalan   10/17/03 - Change the label 
  --   mnihalan   10/13/03 - Fix button rendering 
  --   mnihalan   08/27/03 - Fix dispaly of errors 
  --   mnihalan   08/26/03 - Page not displaying task error 
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   mnihalan   07/23/03 - Add advisor information
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Change the layout
  --   mnihalan   06/10/03 - Change the format
  --   mnihalan   04/17/03 - Move the page header
  --   mnihalan   04/10/03 - Add task info to the page
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/06/03 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvAutoJobConfig"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
    
           <uix:pageStatus>
                  <uix:styledText textBinding="ACTION_AUTO_JOB@stgMsg"
                        styleClass="OraInstructionText"/>
          </uix:pageStatus>
              
              <uix:contents>                
                  <uix:tableLayout width="100%"> 
                    <uix:rowLayout vAlign="top">
                          <uix:cellFormat vAlign="top" width="50%">
                              <uix:header textBinding="CONFIGURATION@stgMsg">
                                        <uix:tableLayout width="100%">
                                            <uix:rowLayout>
                                                  <uix:cellFormat width="100%" hAlign="right">
                                                          <uix:submitButton textBinding="CONFIG_BTN@stgMsg" 
                                                                disabledBinding = "disableConfigure@defaultBean@servletRequest"
                                                                name="event"
                                                                value="<%= JspConstants.CONFIGURE %>"/>                                          
                                                  </uix:cellFormat>
                                            </uix:rowLayout>
                                        </uix:tableLayout width="100%"> 
                                        
                                        <uix:labeledFieldLayout labelWidth="50%">
                                        <uix:contents>
                                        
                                          <uix:messagePrompt
                                              promptBinding="AUTOMATED_TASK@stgMsg"/>
                                          <uix:styledText
                                              styleClass="OraDataText"
                                              textBinding="autoTaskStatus@defaultBean@servletRequest"/>
                                      
                                          <uix:messagePrompt
                                              promptBinding="NEXT_RUN@stgMsg"/>
                                          <uix:styledText textBinding="nextRunDate@defaultBean@servletRequest" 
                                                            styleClass="OraDataText" />
                                          <uix:messagePrompt
                                              promptBinding="WINDOW_NEXT_RUN@stgMsg"/>
                                          <db:link textBinding="nextRunWindow@defaultBean@servletRequest" 
                                                  destination="/console/database/shrinkAdv/shrinkAdv?event=showWindowDetails" copyParams="target,type"/>
                                          
                                          <uix:messagePrompt
                                              promptBinding="RUN_HISTORY@stgMsg"/>
                                          <uix:switcher childNameBinding="enableConfigure@defaultBean@servletRequest">
                                              <uix:case name="false">
                                                  <uix:styledText textBinding="autoJobCount@defaultBean@servletRequest" 
                                                            styleClass="OraDataText" />
                                              </uix:case>
                                              <uix:default>
                                                  <db:link textBinding="autoJobCount@defaultBean@servletRequest" 
                                                           destination="/console/database/instance/schr/jobs?pageName=history&sname=SYS&oname=GATHER_STATS_JOB" copyParams="target,type"/>
                                              </uix:default>
                                          </uix:switcher>    
                                          
                                        </uix:contents>
                                      </uix:labeledFieldLayout>
                                       <uix:tip>
                                          <uix:contents>
                                              <uix:styledText textBinding="SYS_PRIVS2@stgMsg"
                                                                  styleClass="OraMessageBoxParagraph"/>
                                          </uix:contents>
                                       </uix:tip> 
                                    </uix:header>
                               </uix:cellFormat>
                               
                               <uix:cellFormat vAlign="top" width="50%">     
                                  <uix:header textBinding="LAST_RUN_HDR@stgMsg">
                                     <uix:labeledFieldLayout labelWidth="50%">
                                        <uix:contents>
                                         
                                          <uix:messagePrompt
                                              promptBinding="LAST_RUN@stgMsg"/>
                                          <uix:switcher childNameBinding="enableConfigure@defaultBean@servletRequest">
                                              <uix:case name="false">
                                                <uix:styledText
                                                    styleClass="OraDataText"
                                                    textBinding="lastRunDate@defaultBean@servletRequest"/>
                                              </uix:case>
                                              <uix:default>
                                                  <db:link textBinding="lastRunDate@defaultBean@servletRequest" 
                                                          destination="/console/database/shrinkAdv/shrinkAdv?event=viewLastAutoTask" copyParams="target,type"/>
                                              </uix:default>
                                          </uix:switcher>
                                          
                                          <uix:messagePrompt
                                              promptBinding="LAST_RUN_STATUS@stgMsg"/>
                                          <uix:styledText textBinding="lastRunStatus@defaultBean@servletRequest" 
                                                  styleClass="OraDataText" />
                                          
                                          <uix:messagePrompt
                                              promptBinding="RUN_DURATION@stgMsg"/>
                                          <uix:styledText textBinding="lastRunDuration@defaultBean@servletRequest" 
                                                  styleClass="OraDataText" />
                                          
                                          <uix:messagePrompt
                                              prompt=""/>
                                          <db:link textBinding="AUTO_SEGMENTS_PROCESSED@stgMsg"
                                                     destination="/console/database/shrinkAdv/shrinkAdv?event=viewSegsProcessed" copyParams="target,type,sname,oname,cancelURL,otype"/>
                           
                                        </uix:contents>
                                      </uix:labeledFieldLayout>
                                    </uix:header>
                              </uix:cellFormat>
                           </uix:rowLayout>
                        </uix:tableLayout>
                  
                </uix:contents>
              
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
