<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvChainedRow.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Row Chaining page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/17/05  - mnihalan_segment_adv_workflow_change
  --   mnihalan   03/09/05 -  Initial creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>

            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvChainedRow"/>
          
          
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
             
              
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

           <uix:pageStatus>
               <uix:styledText textBinding="CHAINED_ROW_ANALYSIS_INFO@stgMsg"
                              styleClass="OraInstructionText"/>                 
          </uix:pageStatus>
         
          <uix:separator/>
          
           <uix:contents>
              <uix:stackLayout>
             
                   <%--                       --%>
                   <%-- recommendations table --%>
                   <%--                       --%>
                  <uix:dataScope currentDataBinding="recommendationsBean@servletRequest">
                          <jsp:include page="shrinkAdvRecommendationsTable.jsp" />                
                                <uix:ref refID="shrinkAdvTable" />
                  </uix:dataScope>
                             
                          
              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
