<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvOptions.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: ROptions page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   06/23/04 - Add instruction text 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/26/04 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvOptions"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>
          
          <uix:pageButtons>
            <uix:pageButtonBar>
             <uix:submitButton textBinding="SHOW_SQL@stgMsg" 
                        name="event"
                        value="<%= JspConstants.LAUNCH_SHOW_SHRINK_SQL %>" />
             <uix:button textBinding="CANCEL@sdkMsgs" 
                          destinationBinding="cancelURL@servletRequest"/>  
            <uix:submitButton textBinding="IMPLEMENT@stgMsg"
                        name="event"
                        value="<%= JspConstants.LAUNCH_SHRINK_SCHEDULE %>" />
                                      
            </uix:pageButtonBar>
          </uix:pageButtons>
          
           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           </uix:messages>

          <uix:pageStatus>
                  <uix:styledText textBinding="SHRINK_INSTRUCTIONS@schmMsg"
                        styleClass="OraInstructionText"/>
          </uix:pageStatus>
          
          <uix:separator/>
           <uix:contents>
              <uix:stackLayout>
  
                     <%-- Shrink Segments (Offline) --%> 
                     <uix:radioButton name="shrinkOfflineMode"
                                      value="<%= JspConstants.OFFLINE %>"
                                      textBinding="SHRINK_OPT_OFFLINE@schmMsg"
                                      selectedValueBinding="shrinkOfflineMode@shrinkSqlBean@servletRequest" />

                     <uix:rowLayout>
                          <uix:spacer width="22"/>
                                  <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="SHRINK_OPT_OFFLINE_TEXT@schmMsg" />
                      </uix:rowLayout>

                      <%-- Defragment Segments (Online) --%> 
                      <uix:radioButton name="shrinkOfflineMode"
                                      value="<%= JspConstants.ONLINE %>"
                                      textBinding="SHRINK_OPT_ONLINE@schmMsg"
                                      selectedValueBinding="shrinkOfflineMode@shrinkSqlBean@servletRequest" />
                      <uix:rowLayout>
                            <uix:spacer width="22"/>
                            <uix:styledText styleClass="OraInlineInfoText"
                                         textBinding="SHRINK_OPT_ONLINE_TEXT@schmMsg" />
                      </uix:rowLayout>

                                       

              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
