<%--
  -- Page:        shrinkAdvRecomSearch.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Search for Recommendations Include page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/03/09 - Fix search by segment type
  --   mnihalan   03/30/09 - Fix layout
  --   sresrini   03/20/06 - Fix jsp compilation errors
  --   mnihalan   04/26/05 - Fix ada bugs 
  --   mnihalan   03/29/05 - UI review changes 
  --   mnihalan   03/01/05 - Remove tablespace 
  --   mnihalan   08/03/04 - Change lable of Reclaimable space 
  --   mnihalan   06/22/04 - Fix compile error 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/25/04 - Initial Creation
  --%>


<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:tableLayout width="100%">
<uix:rowLayout>
            <uix:cellFormat vAlign="top" width="40%">
                <uix:labeledFieldLayout labelWidth="15%"> 
                         <uix:contents> 
                             <uix:messagePrompt promptBinding="SCHEMA@stgMsg" labeledNodeId="searchSchema"/>    
                             <uix:lovField
                                id="searchSchema"
                                name="searchSchema"
                                columns="20"
                                searchDescBinding="SCHEMA@stgMsg"
                                textBinding="searchSchema@defaultBean@servletRequest"
                                onClick = "startLov('searchSchema', 'ListSchema')"/>
        
                        <uix:messagePrompt promptBinding="SEGMENT_NAME@stgMsg" labeledNodeId="searchObjectName"/>
                        <uix:textInput
                             id="searchObjectName"
                             name="searchObjectName"
                             textBinding="searchObjectName@defaultBean@servletRequest"
                             columns="20"/>
                        
                        <uix:messagePrompt promptBinding="PARTITION_NAME@stgMsg" labeledNodeId="searchPartitionName"/>
                        <uix:textInput
                             id="searchPartitionName"
                             name="searchPartitionName"
                             textBinding="searchPartitionName@defaultBean@servletRequest"
                             columns="20"/>    
                     </uix:contents>
                </uix:labeledFieldLayout> 
            </uix:cellFormat>
              
            <uix:cellFormat vAlign="top" width="40%">
                <uix:labeledFieldLayout labelWidth="35%"> 
                    <uix:contents>  
                        <uix:messagePrompt promptBinding="RECOMMENDATIONS_ACTION@stgMsg" labeledNodeId="recomType"/>
                        <uix:choice
                            id="recomType"
                            name="recomType"
                            selectedValueBinding="recomType@defaultBean@servletRequest">
                            <uix:contents>
                                <uix:option textBinding="ALL_TYPES@stgMsg" valueBinding="ALL_TYPES@stgMsg"/>
                                <uix:option textBinding="SHRINK@stgMsg" value="<%= ShrinkAdvConstants.SHRINK_COMMAND %>"/>
                                <uix:option textBinding="COMPRESS@stgMsg" value="<%= ShrinkAdvConstants.COMPRESS_COMMAND%>"/>
                                <uix:option textBinding="REORGANIZE@stgMsg" value="<%= ShrinkAdvConstants.REORG_COMMAND%>"/>                                                  
                            </uix:contents>
                          </uix:choice>   
                          
                         <uix:messagePrompt promptBinding="RECOMMENDATIONS_MIN_WASTED_SPACE@stgMsg" labeledNodeId="searchSize"/>
                         <uix:textInput
                             id="searchSize"
                             name="searchSize"
                             textBinding="searchSize@defaultBean@servletRequest"
                             columns="20">
                            <uix:onSubmitValidater>
                                <uix:decimal/>
                            </uix:onSubmitValidater>
                          </uix:textInput>  
                          
                          <uix:messagePrompt prompt=""/>
                          <uix:submitButton
                              name="event"
                              value="<%= JspConstants.REC_SEARCH %>"
                              textBinding="SEARCH@stgMsg"/>  
                        </uix:contents>                                          
                    </uix:labeledFieldLayout> 
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="20%">
                </uix:cellFormat>
            </uix:rowLayout>

</uix:tableLayout>

<uix:separator/>
