<%--
  -- Page:        shrinkAdvRecommendationsTable.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/19/09 - Add compress recommendation
  --   mnihalan   04/13/05 - Remove details column 
  --   mnihalan   03/02/05 - Change column order 
  --   mnihalan   10/15/04 - Fix bugs 
  --   mnihalan   10/11/04 - Change column layout 
  --   mnihalan   09/02/04 - Make tablespace name link 
  --   mnihalan   08/05/04 - Add wasted space percent 
  --   mnihalan   06/24/04 - Remove columns 
  --   mnihalan   05/26/04 - Add columns 
  --   mnihalan   01/20/04 - Fix bug 3307526 
  --   mnihalan   10/13/03 - Disable selection 
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   mnihalan   07/30/03 - Make the tablespace name a link
  --   mnihalan   06/09/03 - Add object growth trend
  --   mnihalan   05/27/03 - Add column
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/06/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="shrinkAdvTable">
  <uix:table name="tableList" 
                       alternateTextBinding="FINDINGS_NONE@stgMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10"
                       summaryBinding="RECOMMENDATIONS_TABLE@stgMsg">
                
                    <uix:tableSelection>
                        <uix:multipleSelection
                              renderedBinding="displaySelection@"
                              shortDescBinding="SELECT_RECOMMENDATION@stgMsg"
                              selectedBinding = "<%= ShrinkAdvConstants.SELECTED_ATTR %>"
                              disabledBinding = "<%= ShrinkAdvConstants.DISABLED_ATTR %>"> 
                          <uix:pageButtonBar renderedBinding = "showSpaceSegs@shrinkSqlBean@servletRequest">
                             <uix:submitButton textBinding="SHRINK@stgMsg"
                                              disabledBinding="hasNoShrinkRecommendations@"
                                              name="event"
                                              value="<%= JspConstants.SHRINK %>"/> 
                             <uix:submitButton textBinding="REORGANIZE@stgMsg"
                                              disabledBinding="hasNoReorgRecommendations@"
                                              name="event"
                                              value="<%= JspConstants.REORGANIZE %>"/> 
                             <uix:submitButton textBinding="COMPRESS@stgMsg"
                                              renderedBinding="ifVersion112OrHigher@defaultBean@servletRequest"
                                              disabledBinding="hasNoCompressRecommendations@"
                                              name="event"
                                              value="<%= JspConstants.COMPRESS %>"/> 
                          </uix:pageButtonBar>
                        </uix:multipleSelection>
                   </uix:tableSelection>
                 

                  <%-- Table column Schema column --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_SCHEMA@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_SCHEMA_ATTR%>"/>
                      </uix:contents>
                  </uix:column>
                  
                   <%-- Table column Segment Name --%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_OBJECT@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                   <%-- Table column Recommendation Action--%>
                  <uix:column renderedBinding = "showSpaceSegs@shrinkSqlBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_ACTION@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_ACTIONS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:contents>
                           <uix:button textBinding="<%= ShrinkAdvConstants.RECOM_ACTIONS_ATTR %>"
                                  destinationBinding="<%= ShrinkAdvConstants.RECOM_ACTIONS_LINK_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 
                <%-- Table column reclaimable space--%>
                  <uix:column renderedBinding = "showSpaceSegs@shrinkSqlBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_WASTED_SPACE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_WASTED_SPACE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_WASTED_SPACE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  

                   <%-- Table column Actual Size--%>
                  <uix:column renderedBinding = "showSpaceSegs@shrinkSqlBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_SIZE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_SIZE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_SIZE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column Used Size--%>
                  <uix:column renderedBinding = "showSpaceSegs@shrinkSqlBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_USED_SIZE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_USED_SIZE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_USED_SIZE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  
                  <%-- Table column Chained Row (%)--%>
                  <uix:column renderedBinding = "showChainedRows@shrinkSqlBean@servletRequest">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_CHAINED_ROWS@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_CHAINED_ROWS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="numberFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_CHAINED_ROWS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
		
                 <%-- Table column Object Type--%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_OBJECT_TYPE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 </uix:table>
</uix:buildTree>
