<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvRecommendations.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations page for Shrink Advisor
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/01/09 - Fix compression
  --   mnihalan   02/28/05 - Change in workflow 
  --   mnihalan   09/02/04 - Change the label for time limit 
  --   mnihalan   08/04/04 - mnihalan_seg_adv22
  --   mnihalan   07/19/04 - Add tabs 
  --   mnihalan   05/26/04 - Changes for R2 
  --   mnihalan   04/27/04 - Remove mode 
  --   mnihalan   10/17/03 - Change the label 
  --   mnihalan   10/13/03 - Fix button rendering 
  --   mnihalan   08/27/03 - Fix dispaly of errors 
  --   mnihalan   08/26/03 - Page not displaying task error 
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   mnihalan   07/23/03 - Add advisor information
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Change the layout
  --   mnihalan   06/10/03 - Change the format
  --   mnihalan   04/17/03 - Move the page header
  --   mnihalan   04/10/03 - Add task info to the page
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/06/03 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvRecommendationsTblspc"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

           <uix:pageStatus>
                  <uix:styledText textBinding="recommendationTaskTbInfo@defaultBean@servletRequest"
                        styleClass="OraInstructionText"/>
          </uix:pageStatus>
         
           <uix:contents>
              <uix:stackLayout>
  
                <uix:contents>
                  <%--<uix:header textBinding="TASK_INFO_HDR@stgMsg"> --%>
                       <uix:labeledFieldLayout columns="2">
                            <uix:styledText styleClass="OraPromptText" textBinding="TASK_NAME_LABEL@AdvisorTaskMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="jobName@defaultBean@servletRequest"/>

                            <uix:styledText styleClass="OraPromptText" textBinding="STARTED@AdvisorTaskMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="taskStartDate@defaultBean@servletRequest"/>

                            <uix:styledText styleClass="OraPromptText" textBinding="TASK_STATUS@AdvisorTaskMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="taskStatus@defaultBean@servletRequest"/>

                            <uix:styledText styleClass="OraPromptText" textBinding="ENDED@AdvisorTaskMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="taskEndDate@defaultBean@servletRequest"/>
                      
                            <uix:styledText styleClass="OraPromptText" textBinding="RUNNING_TIME@AdvisorTaskMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="taskRunningTime@defaultBean@servletRequest"/>
 
                            <uix:styledText styleClass="OraPromptText" textBinding="TIME_LIMIT_LIMITED_SECS@stgMsg"/>
                            <uix:styledText styleClass="OraDataText" textBinding="taskTimeLimit@defaultBean@servletRequest"/>
 
                          </uix:labeledFieldLayout>
                <%--  </uix:header>  --%>
          
                   <uix:switcher childNameBinding ="taskError@defaultBean@servletRequest" >
                      <uix:case name="NO_ERROR" >
                          
                         
                         <%-- Tablespace total table --%>
                          <uix:dataScope currentDataBinding="shrinkAdvTablespaceTaskTotalsBean@servletRequest">
                                      <jsp:include page="shrinkAdvTablespaceTotalTable.jsp" />                
                                        <uix:ref refID="shrinkAdvTablespace" />
                        </uix:dataScope>
                            
                        
                        </uix:case>
                         <uix:default>
                            <uix:header textBinding="TASK_ERROR@AdvisorTaskMsg">
                              <uix:contents>
                              <uix:styledText styleClass="OraDataText" 
                                                 textBinding="taskError@defaultBean@servletRequest" />
                              </uix:contents>
                            </uix:header>
                        </uix:default>
                      </uix:switcher>
                  
                </uix:contents>
              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
