<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkAdvSegsProcessed.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Segment Advisor Segments Processed page
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   04/06/05 - Add partition in the search 
  --   mnihalan   03/28/05 - UI exit review changes 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   05/25/04 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="schmMsg"
            class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AdvisorTaskMsg"
            class="oracle.sysman.db.rsc.inst.AdvisorTasksMsg"/>
<uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
            
              
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>
        
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkAdvSegsProcessed"/>

        <uix:pageLayout titleBinding="SEGS_PROCESSED_LAST_RUN@stgMsg">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:pageStatus>
              <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                             <uix:cellFormat vAlign="top" width="50%">
                                <uix:labeledFieldLayout labelWidth="35%">
                                    <uix:contents>
                                      <uix:messagePrompt
                                                  promptBinding="LAST_RUN_TIME@stgMsg"/>    
                                      <uix:styledText
                                                  styleClass="OraDataText"
                                                  textBinding="lastRunDate@defaultBean@servletRequest"/>
                                    </uix:contents>
                                </uix:labeledFieldLayout>                        
                              </uix:cellFormat>
                              <uix:cellFormat vAlign="top" width="20%">
                                  <uix:labeledFieldLayout labelWidth="30%">
                                    <uix:contents>                     
                                        <uix:messagePrompt
                                                    promptBinding="LAST_RUN_STATUS@stgMsg"/>
                                        <uix:styledText textBinding="lastRunStatus@defaultBean@servletRequest" 
                                                    styleClass="OraDataText" />
                                    </uix:contents>
                                   </uix:labeledFieldLayout>  
                                 
                                </uix:cellFormat>
                              <uix:cellFormat vAlign="top" width="30%">
                                 <uix:labeledFieldLayout labelWidth="70%">
                                    <uix:contents>
                                                  
                                      <uix:messagePrompt
                                                promptBinding="RUN_DURATION@stgMsg"/>
                                      <uix:styledText textBinding="lastRunDuration@defaultBean@servletRequest" 
                                                styleClass="OraDataText" />
                                    </uix:contents>
                                   </uix:labeledFieldLayout>  
                                </uix:cellFormat>
                      </uix:rowLayout>
                </uix:tableLayout> 
                            
          </uix:pageStatus>
          <uix:separator/>
           <uix:contents>
              <uix:stackLayout>
  
                <uix:contents>          
                    <uix:styledText textBinding="SEGS_PROCESSED_LAST_RUN_INFO@stgMsg"
                        styleClass="OraInstructionText"/> 
                     <uix:tableLayout width="100%">
                          <uix:rowLayout>
                              <uix:tableLayout cellSpacing="5">
                                  <uix:rowLayout>
                                     
                                         <uix:tableLayout> 
                                           <uix:rowLayout> 
                                              <uix:messagePrompt promptBinding="TABLESPACE@stgMsg" labeledNodeId="searchTablespace"/> 
                                           </uix:rowLayout>     
                                           <uix:rowLayout> 
                                             <uix:lovField
                                                    id="searchTablespace"
                                                    name="searchTablespace"
                                                    columns="15"
						    searchDescBinding="TABLESPACE@stgMsg"
                                                    textBinding="searchTablespace@defaultBean@servletRequest" 
                                                   onClick = "startLov('searchTablespace', 'ListTablespaceAll')"/>  </uix:rowLayout> 
                

                                         </uix:tableLayout> 
                
                                         <uix:tableLayout>
                                           <uix:rowLayout>
                                              <uix:messagePrompt promptBinding="SCHEMA@stgMsg" labeledNodeId="searchSchema"/>    
                                           </uix:rowLayout>
                
                                           <uix:rowLayout>
                                             <uix:lovField
                                                    id="searchSchema"
                                                    name="searchSchema"
                                                    columns="15"
						    searchDescBinding="SCHEMA@stgMsg"
                                                    textBinding="searchSchema@defaultBean@servletRequest"
                                                    onClick = "startLov('searchSchema', 'ListSchema')"/>
                                              
                                            </uix:rowLayout>
                                         </uix:tableLayout>
                                         
                                          <uix:tableLayout>
                                           <uix:rowLayout>
                                            <uix:messagePrompt promptBinding="SEGMENT_NAME@stgMsg" labeledNodeId="searchObjectName"/>
                                               
                                           </uix:rowLayout>
                                           <uix:rowLayout>
                                             <uix:textInput
                                                    id="searchObjectName"
                                                    name="searchObjectName"
                                                    textBinding="searchObjectName@defaultBean@servletRequest"
                                                    columns="15"/> 
                                           </uix:rowLayout>
                                         </uix:tableLayout> 
                
                                         <uix:tableLayout>
                                           <uix:rowLayout>
                                            <uix:messagePrompt promptBinding="PARTITION_NAME@stgMsg" labeledNodeId="searchPartitionName"/>
                                               
                                           </uix:rowLayout>
                                           <uix:rowLayout>
                                             <uix:textInput
                                                    id="searchPartitionName"
                                                    name="searchPartitionName"
                                                    textBinding="searchPartitionName@defaultBean@servletRequest"
                                                    columns="15"/>
                                             <uix:spacer width="5"/>
                                             <uix:submitButton
                                                name="event"
                                                value="<%= JspConstants.SEGS_SEARCH %>"
                                                textBinding="GO@dbMsgs"/>     
                                           </uix:rowLayout>
                                         </uix:tableLayout> 
                                       </uix:rowLayout>
                                       
                               </uix:tableLayout>
                            </uix:rowLayout>
                                   
                        </uix:tableLayout>             
                     <%--                       --%>
                     <%-- Segments Processed table --%>
                     <%--                       --%>
                     <uix:dataScope currentDataBinding="segsProcessedBean@servletRequest">
                          <jsp:include page="shrinkAdvSegsProcessedTable.jsp" />                
                        <uix:ref refID="shrinkAdvTable" />
                    </uix:dataScope>            
                </uix:contents>
              </uix:stackLayout>
          </uix:contents>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
