<%--
  -- Page:        shrinkAdvSegsProcessedTable.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Recommendations table
  --
  --  MODIFIED    (MM/DD/YY
  --   mnihalan   04/06/05 - UI exit review changes 
  --   mnihalan   06/25/04 - Remove a column 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   06/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="shrinkAdvTable">
  <uix:table name="tableList" 
                       alternateTextBinding="FINDINGS_NONE@stgMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10"
                       summaryBinding="RECOMMENDATIONS_TABLE@stgMsg">
                
          
                 <%-- Table column Tablespace Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_TS@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_TS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_TS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  <%-- Table column Schema Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_SCHEMA@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_SCHEMA_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                   <%-- Table column Object Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_OBJECT@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                  
                    <%-- Table column Object Type column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_OBJECT_TYPE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>


                   <%-- Table column Reason column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="REASON@stgMsg" sortableBinding="<%= ShrinkAdvConstants.SORT_REASON_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.REASON_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                   <%-- Table column Task Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="OPTIONS_TASK_NAME@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_TASK_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_TASK_NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                 
                 </uix:table>
</uix:buildTree>