  <%--
  -- Page:        shrinkAdvTablespaceTotal.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Tablespace total table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/26/05 - Fix ADA bugs 
  --   mnihalan   03/24/05 - Add link for recommendation count 
  --   mnihalan   03/23/05 - Add recommendations count 
  --   mnihalan   02/28/05 - Remove recommendation column 
  --   mnihalan   10/12/04 - Change layout 
  --   mnihalan   09/14/04 - Tablespace Total 
  --   mnihalan   09/02/04 - Add extent management 
  --   mnihalan   08/04/04 - Change the recommendation column 
  --   mnihalan   07/19/04 - Add evaluated size 
  --   mnihalan   06/28/04 - Remove column 
  --   mnihalan   06/23/04 - Change width 
  --   mnihalan   06/20/04 - mnihalan_opt_stats12
  --   mnihalan   06/02/04 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.stgAdv.JspConstants" %>


<uix:buildTree nodeID="shrinkAdvTablespace">
  <uix:table name="tablespaceList"
                alternateTextBinding="FINDINGS_NONE@stgMsg"
                formSubmitted="true"
                width="100%"
                tableDataBinding="rowData@"
                minValue="1"
                summaryBinding="RECOMMENDATIONS_TABLE@stgMsg"
                maxValueBinding="numRows@"
                valueBinding="startIndex@"
                blockSize="10">
  
                <uix:tableSelection>
                    <uix:singleSelection selectedIndex="0" 
			shortDescBinding="SELECT_TABLESPACE@stgMsg">
                            <uix:pageButtonBar>
                                  <uix:submitButton
                                      name="event"
                                      value="<%= JspConstants.REC_DETAIL %>"
                                      textBinding="RECOMMENDATION_DETAIL@stgMsg"/>
                                </uix:pageButtonBar>
                          </uix:singleSelection>
                      
                </uix:tableSelection> 
                <%-- Table column Tablespace column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortTablespace@" textBinding="TABLESPACE@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:link textBinding="<%= JspConstants.TABLESPACE_NAME_ATTR %>" destinationBinding="<%= JspConstants.TABLESPACE_LINK_ATTR %>" />
                        </uix:contents>
                </uix:column>
            
                <%-- Table column Recommendation Column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortRecommendationsCount@" textBinding="RECOMMENDATIONS_TO_SHRINK@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:contents>
                        <uix:link textBinding="<%= JspConstants.RECOMMENDATION_COUNT_ATTR %>" destinationBinding="<%= JspConstants.RECOMMENDATION_COUNT_LINK_ATTR %>"/>
                        </uix:contents>
                </uix:column>
                 <%-- Table column Tablespace Size column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortTablespaceSize@" textBinding="TABLESPACE_SIZE@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="<%= JspConstants.TABLESPACE_SIZE_ATTR %>"/>
                        </uix:contents>
                </uix:column>
                
                 <%-- Table column Evaluated Size column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortEvaluatedSize@" textBinding="EVALUATED_SIZE@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="<%= JspConstants.EVALUATED_SIZE_ATTR %>"/>
                        </uix:contents>
                </uix:column>
                
                <%-- Table column Wasted Space(MB) --%>
                <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="RECOMMENDATIONS_WASTED_SPACE@stgMsg"
                                              sortableBinding="sortWastedSpace@"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="<%= JspConstants.WASTED_SPACE_ATTR %>"/>
                        </uix:contents>
                </uix:column>
                    
                <%-- Table column Extent Management column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortExtMgmt@" textBinding="COLUMN_EXTENT_MANAGEMENT@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="<%= JspConstants.EXTENT_MGMT_ATTR %>"/>
                        </uix:contents>
                </uix:column>

                <%-- Table column Segment Space Management column --%>
                <uix:column>
                    <uix:columnHeader>
                          <uix:sortableHeader sortableBinding="sortSegSpaceMgmt@" textBinding="SEG_SPACE_MGMT@stgMsg" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:contents>
                          <uix:styledText textBinding="<%= JspConstants.SEG_SPACE_MGMT_ATTR %>"/>
                        </uix:contents>
                </uix:column>
                         
                      
            </uix:table>
</uix:buildTree>
