<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvBean" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<style>
  .progstyle { position:absolute; }
</style>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
              
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <%-----------------------------------------------------
       -  Progress Page for the Call to the Shrink Advisor
       ------------------------------------------------------%>
      <uix:form
        name="ShrinkAdvisorProgress"
        method="post"
        destination="/console/database/shrinkAdv/shrinkAdv">

        <uix:formValue 
          name="pageName" 
          value="/database/shrinkAdv/shrinkAdvisorProgress"/>

        <uix:formValue 
          name="event" 
          value='<%=JspConstants.CALL_COMPLETE%>'/>
          
        <uix:pageLayout>

          <%@ include file="/database/global.jspf" %>

          <uix:header
            textBinding="pageHeader@defaultBean@servletRequest"
            icon="/em/images/processl.gif">

            <uix:tableLayout width="100%" hAlign="center">

              <uix:rowLayout hAlign="left">
                <uix:styledText 
                  styleClass="OraDataText"
                  textBinding="SHRINK_ADVISOR_SCR_INFO@stgMsg"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer height="10"/>
              </uix:rowLayout>

              <uix:rowLayout hAlign="left">
                <uix:styledText
                  styleClass="OraInstructionText"
                  textBinding="MIN_TO_COMPLETE@stgMsg"/>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer height="20"/>
              </uix:rowLayout>

              <uix:rowLayout hAlign="center">
                <uix:cellFormat hAlign="center">
                  <uix:borderLayout>
                    <uix:stackLayout>

                      <uix:rowLayout>
                        <uix:image
                          source="/em/images/process_animation.gif"/>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:styledText
                          styleClass="OraInstructionText"
                          textBinding="IN_PROGRESS@stgMsg"/>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>

                    </uix:stackLayout>
                  </uix:borderLayout>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:tip>
                      <uix:contents>
                          <uix:styledText textBinding="PROGRESS_TIP@stgMsg"
                                              styleClass="OraMessageBoxParagraph"/>
                      </uix:contents>
                  </uix:tip>
              </uix:rowLayout>

            </uix:tableLayout>

          </uix:header>

        </uix:pageLayout>
      </uix:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>


