<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        shrinkSchedule.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/20/09 - Add Show SQL
  --   rdabbott   06/08/05 - fix modified headers 
  --   mnihalan   05/15/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.ShrinkAdvPages" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
 <uix:bundle name="bundle"                   
          class="oracle.sysman.db.rsc.inst.JobsMsg"/>
  <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="ScheduleBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="DBScheduleBundle"
              class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
       <db:script src="/database/utils.js"/>
        <script>
        function myCallBack(lovwin, event)
        {          
        }
        </script>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
     </uix:metaContainer>

    <uix:body>
        <db:form name="scheduleForm" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
          <uix:formValue name="pageName" value="/database/shrinkAdv/shrinkSchedule"/>
           <uix:formValue name="event" value=""/>
          <uix:pageLayout titleBinding="pageHeader@shrinkSqlBean@servletRequest">
           <%@ include file="/database/global.jspf" %>

           <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
             <uix:submitButton textBinding="SHOW_SQL@stgMsg" 
                        name="event"
                        renderedBinding="hasCompressRecommendation@shrinkSqlBean@servletRequest"
                        value="<%= JspConstants.LAUNCH_SHOW_SHRINK_SQL %>" />
              <uix:button textBinding="CANCEL@sdkMsgs" 
                          destinationBinding="cancelURL@servletRequest"/>
              <uix:submitButton textBinding="SUBMIT@stgMsg"
                                name="event"
                                value="<%= JspConstants.SCHEDULE_SHRINK %>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>


           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
      
          <%-- Schedule page --%>
         <uix:dataScope currentDataBinding="shrinkSqlBean@servletRequest">
              <uix:contents>
                <jsp:include page="shrinkScheduleInclude.jsp" />    
                <uix:ref refID="schedule" />
              </uix:contents> 
          </uix:dataScope>


        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

