<%--
  -- Page:        shrinkScheduleInclude.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to select schema objects in brief mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   07/22/04 - Change the DB Schedule 
  --   mnihalan   06/23/04 - Change schdule page 
  --   chanchan   10/21/03 - Fix ADA issues 
  --   mnihalan   10/17/03 - Change the include page 
  --   mnihalan   09/04/03 - mnihalan_emdw_fix_perf_0901 
  --   mnihalan   08/28/03 - Initital creation
  --%>

<%-- Imports --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="schedule">
      <uix:tip>
          <uix:contents>
                <uix:styledText textBinding="SCHEDULE_INSTR@stgMsg"
                                                  styleClass="OraMessageBoxParagraph"/>
          </uix:contents>
        </uix:tip>
             
              <uix:header textBinding="SCHED_JOB_INFO_HDR@stgMsg">
                <uix:labeledFieldLayout labelWidth="15%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="OPTIONS_JOB_NAME@stgMsg"
                        required="yes"
                        labeledNodeId="jobName"/>
                    <uix:textInput
                        id="jobName"
                        name="<%= JspConstants.JOB_NAME %>"
                        textBinding="jobName@"
                        columns="60"/>
                    <uix:messagePrompt
                        promptBinding="OPTIONS_JOB_DESC@stgMsg"
                        labeledNodeId="jobDescription"/>
                    <uix:textInput
                        id="jobDescription"
                        name="jobDescription"
                        textBinding="jobDescription@"
                        columns="60"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:header>
              
              <uix:header textBinding="SCHED_OPTIONS_HEADER@stgMsg">
                  <jsp:include page="/database/instance/scheduler/scheduleType.jsp" />                
                    <uix:ref refID="scheduleType" />    
              </uix:header>
              
</uix:buildTree>