<%--
  -- Page:        wizAddSchemaObjects.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.StgAdvController
  --
  -- Description: Page to add a schema object to the selected schema objects
  --
  --  MODIFIED    (MM/DD/YY)
  --   sshastry   03/20/06 - 
  --   mnihalan   04/26/05 - Fix ADA bug 
  --   mnihalan   08/10/04 - Change remove functionality 
  --   mnihalan   05/10/04 - Use generic LOV 
  --   mnihalan   08/12/03 - Fix ADA issues 
  --   mnihalan   04/07/03 - Add title to pageLayout
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Fix the lov fields
  --   mnihalan   01/27/03 - Initial creation
  --%>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
            <uix:separator/>
            <uix:header textBinding="SEARCH@stgMsg">
              <uix:contents>
                <uix:labeledFieldLayout labelWidth="15%"> 
                 <uix:contents> 
                      
                        <uix:messagePrompt promptBinding="TYPE@stgMsg" labeledNodeId="searchType"/>
                        <uix:choice
                            id="searchType"
                            name="searchType"
                            selectedValueBinding="searchType@defaultBean@servletRequest">
                          <uix:contents>
                            <uix:option textBinding="ALL_TYPES@stgMsg" valueBinding="ALL_TYPES@stgMsg"/>
                            <uix:option textBinding="TABLES@stgMsg" valueBinding="TABLES@stgMsg"/>
                            <uix:option textBinding="INDEXES@stgMsg" valueBinding="INDEXES@stgMsg"/>
                            <uix:option textBinding="TABLE_PARTS@stgMsg" valueBinding="TABLE_PARTS@stgMsg"/>
                            <uix:option textBinding="INDEX_PARTS@stgMsg" valueBinding="INDEX_PARTS@stgMsg"/>
                         </uix:contents>
                        </uix:choice>
                      
                        <uix:messagePrompt promptBinding="SCHEMA@stgMsg" labeledNodeId="searchSchema"/>    
                         <uix:lovField
                            id="searchSchema"
                            name="searchSchema"
                            columns="30"
			    searchDescBinding="SCHEMA@stgMsg"
                            textBinding="searchSchema@defaultBean@servletRequest"
                            onClick = "startLov('searchSchema', 'ListSchema')"/>
                           
                        <uix:messagePrompt promptBinding="OBJECT_NAME@stgMsg" labeledNodeId="searchObjectName"/>
                         <uix:textInput
                            id="searchObjectName"
                            name="searchObjectName"
                            textBinding="searchObjectName@defaultBean@servletRequest"
                            columns="30"/>
                    
                        <uix:messagePrompt promptBinding="PARTITION_NAME@stgMsg" labeledNodeId="searchPartitionName"/>
                        <uix:textInput
                            id="searchPartitionName"
                            name="searchPartitionName"
                            textBinding="searchPartitionName@defaultBean@servletRequest"
                            columns="30"/>

                        <uix:messagePrompt promptBinding="SUBPARTITION_NAME@stgMsg" labeledNodeId="searchSubPartitionName"/>
                        <uix:textInput
                            id="searchSubPartitionName"
                            name="searchSubPartitionName"
                            textBinding="searchSubPartitionName@defaultBean@servletRequest"
                            columns="30"/>
                     
                      <uix:messagePrompt promptBinding="TABLESPACE@stgMsg" labeledNodeId="searchTablespace"/> 
                      <uix:lovField
                        id="searchTablespace"
                        name="searchTablespace"
                        columns="30"
                        textBinding="searchTablespace@defaultBean@servletRequest" 
			searchDescBinding="TABLESPACE@stgMsg"
                       onClick = "startLov('searchTablespace', 'ListTablespace')"/>

                      <uix:messagePrompt promptBinding="SIZE@stgMsg" labeledNodeId="searchSize"/>
                      <uix:textInput
                          id="searchSize"
                          name="searchSize"
                          textBinding="searchSize@defaultBean@servletRequest"
                          columns="10">
                        <uix:onSubmitValidater>
                          <uix:decimal/>
                        </uix:onSubmitValidater>
                      </uix:textInput>
  
                 
                    <uix:messagePrompt prompt=""/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.ADD_SCHEMA_OBJECTS_SEARCH %>"
                        textBinding="SEARCH@stgMsg"/>
        
                  </uix:contents>
                </uix:labeledFieldLayout> 
             </uix:contents> 
            </uix:header>
            
            <uix:header textBinding="AVAIL_SCHEMA_OBJECTS@stgMsg">
              <uix:contents>
        
              <uix:dataScope currentDataBinding="shrinkAdvSchemaObjectsBean@servletRequest">
                <jsp:include page="wizAddSchemaObjectsTable.jsp" /> 
                    
                  <uix:ref refID="wizShrinkAdvTable" />
                </uix:dataScope>
              </uix:contents>
            </uix:header>

          
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_OBJECTS_CANCEL %>"
                    textBinding="CANCEL@sdkMsgs"/>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMA_OBJECTS_OK %>"
                    textBinding="OK@sdkMsgs"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
         
