<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAddSchemas.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.StgAdvController
  --
  -- Description: Page to add a schema to the selected schemas
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   08/10/04 - Change remove functionality 
  --   hsu        07/25/03 - change global
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/16/03 - Fix bug with duplicate db tag
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/11/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizAddSchemas"/>

        <uix:pageLayout>
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%--       --%>
          <%-- Train --%>
          <%--       --%>
          <uix:location>
            <%-- Train --%>
            <%@ include file="wizTrain.jsp" %>
          </uix:location>

        
          <uix:messageBox automatic="true" dataNameBinding = "messageData@shrinkAdvTablespaceBean@servletRequest" />
          <uix:contents>
            <uix:header textBinding="pageHeader@defaultBean@servletRequest">
              
                <uix:separator>
                  <uix:spacer width="1" height="5"/>
                </uix:separator>
      
            <uix:header textBinding="SEARCH@stgMsg">
              <uix:contents>
                    <uix:messagePrompt promptBinding="SCHEMA@stgMsg"/>
                    <uix:spacer width="5"/>
                    <uix:textInput
                        name="searchObjectName"
                        textBinding="searchObjectName@defaultBean@servletRequest"
                        columns="30"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton
                        name="event"
                        value="<%= JspConstants.ADD_SCHEMAS_SEARCH %>"
                        textBinding="SEARCH@stgMsg"/>
              </uix:contents>
            </uix:header>
            
            <uix:header textBinding="AVAIL_OBJECTS@stgMsg">
              <uix:contents>
        
              <uix:dataScope currentDataBinding="shrinkAdvSchemaBean@servletRequest">
                <jsp:include page="wizSchemasTable.jsp" /> 
                    
                  <uix:ref refID="wizShrinkAdvTable" />
                </uix:dataScope>
              </uix:contents>
            </uix:header>

           </uix:header>          
          </uix:contents>
          
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMAS_CANCEL %>"
                    textBinding="CANCEL@sdkMsgs"/>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_SCHEMAS_OK %>"
                    textBinding="OK@sdkMsgs"/>
              </uix:pageButtonBar>
            </uix:pageButtons>
            
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
