<%--
  -- Page:        wizAddTablespaces.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.StgAdvController
  --
  -- Description: Page to add a tablespace to the selected tablespaces
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   08/10/04 - Change remove functionality 
  --   mnihalan   06/23/04 - Show tip only for 10gR1 
  --   mnihalan   08/12/03 - Fix ada issues 
  --   mnihalan   06/17/03 - Change layout
  --   mnihalan   04/17/03 - Move the tip
  --   mnihalan   04/07/03 - Add title to pageLayout
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   01/27/03 - Initial creation
  --%>


<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
        
        <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

         <uix:contents>
             <uix:separator/>           
            <uix:header textBinding="SEARCH@stgMsg">
                <uix:labeledFieldLayout labelWidth="5%"> 
                  <uix:contents>
                    <uix:messagePrompt promptBinding="TABLESPACE@stgMsg" labeledNodeId="searchObjectName"/>
                    <uix:flowLayout>
                      <uix:textInput
                          id="searchObjectName"
                          name="searchObjectName"
                          textBinding="searchObjectName@defaultBean@servletRequest"
                          columns="30"/>
                      <uix:spacer width="5"/>
                      <uix:submitButton
                          name="event"
                          value="<%= JspConstants.ADD_TABLESPACE_SEARCH %>"
                          textBinding="SEARCH@stgMsg"/>   
                    </uix:flowLayout>
                </uix:contents>
              </uix:labeledFieldLayout>
            </uix:header>
            
            <uix:header textBinding="AVAIL_TABLESPACE_OBJECTS@stgMsg">
              <uix:contents>
        
                <uix:dataScope currentDataBinding="shrinkAdvTablespaceBean@servletRequest">
                  <jsp:include page="wizAddTablespacesTable.jsp" /> 
                    
                    <uix:ref refID="wizShrinkAdvTable" />
                </uix:dataScope>
                <uix:spacer height="10"/>
                <uix:tip renderedBinding="ifVersion10GR1@defaultBean@servletRequest">
                    <uix:contents>
                        <uix:styledText textBinding="TABLESPACE_TYPE_TIP@stgMsg"
                                            styleClass="OraMessageBoxParagraph"/>
                    </uix:contents>
                </uix:tip>
              </uix:contents>
            </uix:header>
 
          </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_TABLESPACE_CANCEL %>"
                    textBinding="CANCEL@sdkMsgs"/>
                <uix:submitButton
                    name="event"
                    value="<%= JspConstants.ADD_TABLESPACE_OK %>"
                    textBinding="OK@sdkMsgs"/>
              </uix:pageButtonBar>
          </uix:pageButtons>