<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAddTablespacesDetailed.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.StgAdvController
  --
  -- Description: Page to add a tablespace to the selected tablespaces
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   04/05/05 - Handle user hitting enter on page 
  --   mnihalan   05/27/04 - Change page status 
  --   mnihalan   01/22/04 - Cache manage changes 
  --   mnihalan   09/12/03 - Add tablespace msg resource bundle 
  --   mnihalan   08/12/03 - Fix ADA issues 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Add browser title
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/07/03 - Add title to pageLayout
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Initial creation
  --%>
</script>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="tbMsg"
            class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
      <db:script src="/database/utils.js"/>
    </uix:metaContainer>
    
    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,sname,oname,otype">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizAddTablespacesDetailed"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          
          <uix:location>
               <%@ include file="wizTrain.jsp" %>
          </uix:location>

          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
        
          <%@ include file="wizAddTablespaces.jsp" %>
          
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
