<%--
  -- Include:     wizNavigation.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Included navigation buttons for the Storage Advisor wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   05/27/04 - Add scope step 
  --   mnihalan   04/27/04 - Change num steps 
  --   mnihalan   06/18/03 - Add Show SQL button
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/26/03 - Remove the review
  --   mnihalan   01/22/03 - Change the cancel button
  --   jochen     01/17/03 - jochen_stgadv
  --   jochen     10/21/02 - Initial entry
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="wizNavigation">
  <uix:pageButtonBar>
    <uix:button textBinding="CANCEL@sdkMsgs" 
                destinationBinding="cancelURL@servletRequest"/>

    <uix:submitButton name="event"
                value="<%= JspConstants.SHOW_SQL %>" 
                renderedBinding="isLastStep@defaultBean@servletRequest"
                textBinding="SHOW_SQL@stgMsg"/>
    <uix:navigationBar name="tableNav"
                       blockSize="-1"
                       formSubmitted="true"
                       formName="foo"
                       maxValueBinding ="numSteps@defaultBean@servletRequest"
                       minValue="1"
                       valueBinding="pageSequence@defaultBean@servletRequest"/>
    <uix:submitButton textBinding="SUBMIT@stgMsg"
                      name="event"
                      renderedBinding="showSubmit@defaultBean@servletRequest"
                      value="<%= DBJobParams.EVENT_FINISH %>" />
  </uix:pageButtonBar>
</uix:buildTree>


        
