<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizOtpions.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Options page in the wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   01/22/04 - Fix cache manager changes 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Add browser title
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/08/03 - Change the target name header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/05/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.ShrinkAdvPages" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
        <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,sname,oname,otype">
          <uix:formValue name="pageName" value="/database/shrinkAdv/wizOptions"/>
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
           <%@ include file="/database/global.jspf" %>

            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	<uix:location>
            	<%-- Train --%>
            	<%@ include file="wizTrain.jsp" %>
          	</uix:location>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           </uix:messages>
          
          	<%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>

          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <uix:labeledFieldLayout labelWidth="10%">
                <uix:contents>
                  <uix:messagePrompt
                      promptBinding="DATABASE@uixDBObjectBundle@servletRequest"/>
                  <uix:styledText
                      styleClass="OraDataText"
                      textBinding="targetName@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>    
          
            <%-- Page that displays the Contents of the Options page --%>
            <%@ include file="wizOptionsInclude.jsp" %>
        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

