<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizRelatedSegments.jsp
  -- Controller:  oracle.sysman.db.util.stgAdv.StgAdvController
  --
  -- Description: Related Segments page
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      12/08/06 - 
  --   mnihalan   08/16/05 - Fix bug 4555126 
  --   mnihalan   05/27/04 - Add page status 
  --   mnihalan   01/22/04 - Cache manager changes 
  --   hsu        07/25/03 - change global
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/12/03 - Initial Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,oname,sname,">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizRelatedSegmentsDetailed"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>
          
          <uix:switcher childNameBinding="displayInformation@servletRequest">
                <uix:case name="true">                                             
                 <uix:messageBox automatic="false"
                                        messageBinding="jobInfo@servletRequest"
                                        textBinding="AUTO_JOB_INFO_HDR@stgMsg"
                                        messageType="information">
                          <uix:flowLayout>
                             <uix:link textBinding="recomInfo@servletRequest" 
                                    destinationBinding="recomPage@servletRequest" renderedBinding="ifVersionNot11OrHigher@defaultBean@servletRequest" />
                          </uix:flowLayout>
                </uix:messageBox>
           </uix:case>
           </uix:switcher>

          <%--       --%>
          <%-- Train --%>
          <%--       --%>
          <uix:location>
            <%@ include file="wizTrain.jsp" %>
          </uix:location>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  destTableBinding="urls@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
         </uix:messages>
        
         <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          
      
          <uix:separator/>   
          
          <%-- Navigation buttons --%>
          <%--                    --%>
          <jsp:include page="wizNavigation.jsp" />
          <uix:pageButtons>
                <uix:stackLayout>
                  <uix:ref refID="wizNavigation" />
                  <uix:spacer height="2"/>
                </uix:stackLayout>
          </uix:pageButtons>

           <%-- Page that displays the table of objects --%>
          <%@ include file="wizRelatedSegments.jsp" %>

          <%-- Options --%>
          <uix:header textBinding="TRAIN_OPTIONS@stgMsg">
               <uix:hideShow id="optionsHideShow"
                    undisclosedTextBinding="SCOPE_SHOW_OPTIONS@stgMsg"
                    disclosedTextBinding="SCOPE_HIDE_OPTIONS@stgMsg"
                    disclosedBinding="optionsHideShow@defaultBean@servletRequest"
                    formName="foo"
                    formSubmitted="true">
                             <%@ include file="wizOptionsInclude.jsp" %>
                </uix:hideShow>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
