<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizReview.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Review page for wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   05/27/04 - Change page status 
  --   mnihalan   04/27/04 - Remove mode 
  --   mnihalan   01/22/04 - Cache manager change 
  --   mnihalan   09/22/03 - Fix time limit display 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Remove automatic Shrink
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/15/03 - mnihalan_emdw_shrink
  --   mnihalan   04/02/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,oname,sname,otype">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizReview"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          
          <uix:location>
               <%@ include file="wizTrain.jsp" %>
          </uix:location>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

           <%--                    --%>
          <%-- Navigation buttons --%>
          <%--                    --%>
          <jsp:include page="wizNavigation.jsp" />
          <uix:pageButtons>
                <uix:stackLayout>
                  <uix:ref refID="wizNavigation" />
                  <uix:spacer height="2"/>
                </uix:stackLayout>
          </uix:pageButtons>

          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          

          <uix:separator/>  

          <uix:contents>
                    <uix:labeledFieldLayout labelWidth="25%"> 
                        <uix:contents>   
                            
                            <uix:messagePrompt promptBinding="OPTIONS_TASK_NAME@stgMsg" />
                            <uix:styledText textBinding="jobName@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 

                            <uix:messagePrompt promptBinding="OPTIONS_TASK_DESC@stgMsg"/>
                            <uix:styledText textBinding="jobDescription@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 
                             
                            <uix:messagePrompt promptBinding="TIME_LIMIT_SEC@stgMsg"/>
                            <uix:styledText textBinding="timeLimitDisplay@defaultBean@servletRequest"
                                    styleClass="OraDataText" /> 
                             
                            <uix:messagePrompt promptBinding="RETAIN_ADVISOR_RESULTS@stgMsg"/>
                            <uix:styledText textBinding="numDaysToRetain@defaultBean@servletRequest"
                                      styleClass="OraDataText" />  
                        </uix:contents>
                   </uix:labeledFieldLayout>
                           
                  <uix:spacer height="5" />  
                  <uix:header textBinding="SELECTED_OBJECTS@stgMsg" >
                    <uix:contents>
                      <uix:dataScope currentDataBinding="shrinkAdvSelectedObjectsBean@servletRequest">
                                    <jsp:include page="wizSelectedObjectsTable.jsp" />                
                                    <uix:ref refID="wizShrinkAdvTable" />
                      </uix:dataScope>
                    </uix:contents>
                  </uix:header>
          </uix:contents>

          
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
