<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSchedule.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Schedule page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   02/21/07 - Fix bug 5885460
  --   mnihalan   05/10/04 - Add finish button 
  --   mnihalan   04/27/04 - Change number of steps 
  --   mnihalan   01/22/04 - Cache manager change 
  --   mnihalan   11/11/03 - Fix scheduling in maintenance window 
  --   mnihalan   09/16/03 - Fix schedule 
  --   mnihalan   08/12/03 - Fix ADA issues 
  --   hsu        07/25/03 - change global
  --   mnihalan   05/16/03 - Add datascope to include the Schedule page
  --   mnihalan   04/08/03 - Change the target name header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/05/03 - Add code
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.ShrinkAdvPages" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="bundle"                   
          class="oracle.sysman.db.rsc.inst.JobsMsg"/>
  <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="ScheduleBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="DBScheduleBundle"
          class="oracle.sysman.db.rsc.inst.ScheduleMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <db:script src="/database/utils.js"/>
      <script>
      function myCallBack(lovwin, event)
      {          
      }
      function lovCallBack(selectedValue, selectedValue1)
      {
        document.forms[0].queueSchema.value=selectedValue;
        document.forms[0].queueObject.value=selectedValue1;
        submitForm(document.forms[0].name, true,{event:'getAgent'})
      }
      </script>

      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
        <db:form name="scheduleForm" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,sname,oname,otype">
          <uix:formValue name="pageName" value="/database/shrinkAdv/wizSchedule"/>
          <uix:formValue name="event" value=""/>
          <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
           <%@ include file="/database/global.jspf" %>

            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	<uix:location>
            	<%-- Train --%>
            	<%@ include file="wizTrain.jsp" %>
          	</uix:location>

           <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          	<%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>

             <%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL@sdkMsgs" 
                        destinationBinding="cancelURL@servletRequest"/>

                  <uix:navigationBar name="tableNav"
                                     blockSize="-1"
                                     formSubmitted="true"
                                     formName="scheduleForm"
                                     maxValueBinding="numSteps@defaultBean@servletRequest"
                                     minValue="1"
                                     valueBinding="pageSequence@defaultBean@servletRequest"/>
                  <uix:submitButton textBinding="SUBMIT@stgMsg"
                      name="event"
                      value="<%= DBJobParams.EVENT_FINISH %>" />
    
              </uix:pageButtonBar>
            </uix:pageButtons>

          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          

          <uix:separator/>  
          <%-- Page that displays the table of objects --%>
           <uix:dataScope currentDataBinding="defaultBean@servletRequest">
              <uix:contents>
                <jsp:include page="wizTaskScheduleInclude.jsp" />    
                <uix:ref refID="schedule" />
              </uix:contents> 
          </uix:dataScope>


        </uix:pageLayout>
    	</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

