<%--
  -- Page:        wizScheduleInclude.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to select schema objects in brief mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   08/12/03 - Fix ADA issues 
  --   mnihalan   06/17/03 - Change layout
  --   mnihalan   05/27/03 - Add job info header
  --   mnihalan   04/22/03 - Add message to user name and password
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/10/03 - Initital creation
  --%>

<%-- Imports --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="schedule">
      <uix:tip>
          <uix:contents>
                <uix:styledText textBinding="SCHEDULE_INSTR@stgMsg"
                                                  styleClass="OraMessageBoxParagraph"/>
          </uix:contents>
        </uix:tip>
             
              <uix:header textBinding="SCHED_JOB_INFO_HDR@stgMsg">
                <uix:labeledFieldLayout labelWidth="15%">
                  <uix:contents>
                    <uix:messagePrompt
                        promptBinding="OPTIONS_JOB_NAME@stgMsg"
                        required="yes"
                        labeledNodeId="jobName"/>
                    <uix:textInput
                        id="jobName"
                        name="<%= JspConstants.JOB_NAME %>"
                        textBinding="jobName@"
                        columns="60"/>
                    <uix:messagePrompt
                        promptBinding="OPTIONS_JOB_DESC@stgMsg"
                        labeledNodeId="jobDescription"/>
                    <uix:textInput
                        id="jobDescription"
                        name="jobDescription"
                        textBinding="jobDescription@"
                        columns="60"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:header>
              <uix:header textBinding="SCHED_OPTIONS_HEADER@stgMsg">
                   <%@ include file="/sdk/schedule/schedule.jspf" %>
              </uix:header>
              
</uix:buildTree>
    