<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="HDR_SEARCH_SEL_SCHEMA@stgMsg"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        <uix:form name="foo" method="post" destinationBinding="destination@selectSchemaBean@servletRequest">
        --%>
          <uix:listOfValues
              titleBinding="SCHEMA_LOV@stgMsg"
              searchTextBinding="searchCriteria@defaultBean@servletRequest">
            <uix:formValue name="pageName" value="/database/shrinkAdv/wizSchemaLov"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_SCHEMA_INSTR@stgMsg"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="selectSchemaBean"
                  alternateTextBinding="NO_SCHEMAS@stgMsg"
                  name="schemaDataSource"
                  dataSourceProp="schemaDataSource"
                  width="100%"
                  blockSize="10"
                  formSubmitted="true"
                  proxied="true">
                <uix:tableSelection>
                  <uix:singleSelection selectedIndex="0"/>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
        <%--</uix:form>--%>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

