<%--
  -- Page:        wizSchemasTable.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Schema table
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/11/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="wizShrinkAdvTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_SCHEMAS@stgMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10">
                
                    <uix:tableSelection>
                      <uix:switcher childNameBinding="<%= ShrinkAdvConstants.SELECT_TYPE_ATTR %>">
                        <uix:case name="<%= ShrinkAdvConstants.MULTI_SELECT %>">
                          <uix:multipleSelection
                              selectedBinding = "<%= ShrinkAdvConstants.SELECTED_ATTR %>">
                          </uix:multipleSelection>
                        </uix:case>
                        <uix:case name="<%= ShrinkAdvConstants.SINGLE_SELECT %>">
                          <uix:singleSelection selectedIndex="0">
                            <uix:pageButtonBar>
                                  <uix:submitButton
                                      name="event"
                                      value="<%= JspConstants.REMOVE_SCHEMAS %>"
                                      textBinding="REMOVE@sdkMsgs"/>
                                </uix:pageButtonBar>

                          </uix:singleSelection>
                        </uix:case>
                      </uix:switcher>
                   </uix:tableSelection>
                 
                 <%-- Table column Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="COLUMN_NAME@stgMsg" sortableBinding="<%= ShrinkAdvConstants.SORT_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                 </uix:table>
</uix:buildTree>