<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        problems.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Start page for the DB Storage Advisor wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      12/08/06 - 
  --   sshastry   03/20/06 - 
  --   mnihalan   08/16/05 - Fix position of messagebox 
  --   mnihalan   08/16/05 - Fix bug 4555126 
  --   mnihalan   05/27/04 - Make Scope part of the wizard 
  --   mnihalan   04/27/04 - Remove mode 
  --   hsu        07/25/03 - change global
  --   mnihalan   04/17/03 - Add cancel URL
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/12/03 - Change header
  --   mnihalan   02/25/03 - Add code
  --   mnihalan   01/21/03 - Add code
  --   jochen     01/17/03 - jochen_stgadv
  --   jochen     10/21/02 - Initial entry based on kmckeen prototype
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.ShrinkAdvPages" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.db.util.DBJobParams" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,sname,oname,otype">
      <uix:formValue name="pageName" value="/database/shrinkAdv/wizScope"/>
      
        <uix:pageLayout titleBinding="START_HEADER_BC@stgMsg">
        
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>
          <uix:switcher childNameBinding="displayInformation@servletRequest">
                <uix:case name="true">                                             
                 <uix:messageBox automatic="false"
                                        messageBinding="jobInfo@servletRequest"
                                        textBinding="AUTO_JOB_INFO_HDR@stgMsg"
                                        messageType="information">
                          <uix:flowLayout>
                             <uix:link textBinding="recomInfo@servletRequest" 
                                    destinationBinding="recomPage@servletRequest" renderedBinding="ifVersionNot11OrHigher@defaultBean@servletRequest"/>
                          </uix:flowLayout>
                </uix:messageBox>
           </uix:case>
          </uix:switcher>  
          <uix:messages>
                  <oem:messageBox
                      messageTypeBinding="messageType@servletRequest"
                      errorTableBinding="errors@servletRequest"    
                      destTableBinding="urls@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
                  
          </uix:messages>   
          
         
            <%--       --%>
          	<%-- Train --%>
          	<%--       --%>
          	<uix:location>
            	<%-- Train --%>
            	<%@ include file="wizTrain.jsp" %>
          	</uix:location>
          
            <%--                    --%>
            <%-- Navigation buttons --%>
            <%--                    --%>
            <jsp:include page="wizNavigation.jsp" />
            <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
            </uix:pageButtons>
          
          
           <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
      
    
          <uix:separator/>   
          
          <uix:contents>
               <uix:spacer width="10" height="3"/>
               
              <uix:rowLayout>

                <%--               --%>
                <%-- Radio buttons --%>
                <%--               --%>
                <uix:cellFormat width="65%" vAlign="top">
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer width="3" height="5"/>
                    </uix:separator>

                    <uix:rowLayout>
                      <uix:spacer width="15" height="1"/>

                      <uix:stackLayout>
                        <uix:styledText textBinding="START_ADVICE_FOR@stgMsg"
                                          styleClass="OraInstructionText"/>
                        <uix:radioButton textBinding="SCOPE_TABLESPACES@stgMsg"
                                          name="launchType"
                                          selectedValueBinding="launchType@defaultBean@servletRequest"
                                          value="<%= JspConstants.TABLESPACE %>"/>
                        <uix:radioButton textBinding="SCOPE_SCHEMAS@stgMsg" 
                                          name="launchType"
                                          selectedValueBinding="launchType@defaultBean@servletRequest"
                                          value="<%= JspConstants.SCHEMA %>"/>
                      </uix:stackLayout>
                    </uix:rowLayout>

                  </uix:stackLayout>
                
                </uix:cellFormat>
                <uix:spacer width="10"/>

                <%--              --%>
                <%-- Overview box --%>
                <%--              --%>
                <uix:cellFormat width="40%" vAlign="top">
                  <uix:contentContainer textBinding="SCOPE_OVERVIEW@stgMsg" width="100%">
                    <uix:stackLayout>
                      <uix:separator>
                        <uix:spacer width="10" height="7"/>
                      </uix:separator>
                      <uix:contents>
                        <uix:styledText textBinding="SCOPE_OVERVIEW_P1@stgMsg"
                                        styleClass="OraInstructionText"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contentContainer>
                </uix:cellFormat>
              </uix:rowLayout>
       
        </uix:contents>
      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
