<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectSchemaObjectsBrief.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to select schema objects in brief mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/17/03 - Change layout
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/08/03 - Change the header
  --   mnihalan   03/19/03 - Add target and types
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/05/03 - Add code
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizSelectSchemaObjectsBrief"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
                 <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="SCHEMA_ADD_OBJECTS_INSTR@stgMsg"/>
          </uix:pageStatus>
         
          <%--                    --%>
          <%-- Navigation buttons --%>
          <%--                    --%>
          <uix:pageButtons>
              <uix:pageButtonBar>
                  <uix:button textBinding="CANCEL@sdkMsgs" 
                              destinationBinding="cancelURL@servletRequest"/>
                  <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                    name="event"
                                    value="<%= JspConstants.START_BRIEF %>" />
              </uix:pageButtonBar>             
        </uix:pageButtons>

        
         <%-- Page that displays the table of objects --%>
         <%@ include file="wizSelectSchemas.jsp" %>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
