<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectSchemaObjectsDetailed.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to select schemas objects in detailed mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   ychan      12/08/06 - 
  --   mnihalan   08/16/05 - Fix bug 4555126 
  --   mnihalan   05/27/04 - Change page status 
  --   mnihalan   04/27/04 - Add options 
  --   mnihalan   01/22/04 - Cache manager changes 
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/18/03 - Add browser title
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/08/03 - Change the header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   02/28/03 - Add code
  --   mnihalan   02/24/03 - Add code
  --   mnihalan   02/11/03 - Initital creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,oname,otype,sname">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizSelectSchemaObjectsDetailed"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>
          
            <uix:switcher childNameBinding="displayInformation@servletRequest">
                <uix:case name="true">                                             
                 <uix:messageBox automatic="false"
                                        messageBinding="jobInfo@servletRequest"
                                        textBinding="AUTO_JOB_INFO_HDR@stgMsg"
                                        messageType="information">
                          <uix:flowLayout>
                             <uix:link textBinding="recomInfo@servletRequest" 
                                      destinationBinding="recomPage@servletRequest" renderedBinding="ifVersionNot11OrHigher@defaultBean@servletRequest" />
                          </uix:flowLayout>
                </uix:messageBox>
           </uix:case>
          </uix:switcher>
          
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  destTableBinding="urls@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <uix:location>
                   <%--       --%>
                    <%-- Train --%>
                    <%--       --%>
                    <%@ include file="wizTrain.jsp" %>
          </uix:location>

    

        <%-- Use the pageStatus tag to provide page/wizard context (target name) --%>
          <uix:pageStatus>
              <%@ include file="wizPageStatus.jsp" %>
          </uix:pageStatus>
          
      
          <uix:separator/>    
          
        <%--                    --%>
        <%-- Navigation buttons --%>
        <%--                    --%>
        <jsp:include page="wizNavigation.jsp" />
        <uix:pageButtons>
              <uix:stackLayout>
                <uix:ref refID="wizNavigation" />
                <uix:spacer height="2"/>
              </uix:stackLayout>
        </uix:pageButtons>

         <%-- Page that displays the table of objects --%>
         <%@ include file="wizSelectSchemas.jsp" %>

         <%-- Options --%>
          <uix:header textBinding="TRAIN_OPTIONS@stgMsg">
               <uix:hideShow id="optionsHideShow"
                    undisclosedTextBinding="SCOPE_SHOW_OPTIONS@stgMsg"
                    disclosedTextBinding="SCOPE_HIDE_OPTIONS@stgMsg"
                    disclosedBinding="optionsHideShow@defaultBean@servletRequest"
                    formName="foo"
                    formSubmitted="true">
                             <%@ include file="wizOptionsInclude.jsp" %>
                </uix:hideShow>
          </uix:header>
           
      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>        
         
