<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizSelectTablespacesBrief.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Select tablespaces brief page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   09/12/03 - Add tablespace msg resource bundle 
  --   hsu        07/25/03 - change global
  --   mnihalan   06/17/03 - Change layout
  --   qsong      04/29/03 - Add oemTop.jspf
  --   mnihalan   04/08/03 - Change the header
  --   mnihalan   03/19/03 - Add target, type
  --   mnihalan   03/13/03 - mnihalan_trans_shrink_adv
  --   mnihalan   03/05/03 - Add code
  --   mnihalan   02/28/03 - Initital creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:renderingContext id="renderingContext">

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="tbMsg"
            class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>

<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

     <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizSelectTablespacesBrief"/>
        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">

         <%@ include file="/database/global.jspf" %>
        
          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

           <uix:pageStatus>
                 <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="TS_ADD_TABLESPACE_INSTR@stgMsg"/>
          </uix:pageStatus>
    
          <uix:pageButtons>
               <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@sdkMsgs" 
                                  destinationBinding="cancelURL@servletRequest"/>
                    <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                name="event"
                                value="<%= JspConstants.START_BRIEF %>" />
              </uix:pageButtonBar>
          </uix:pageButtons>
          
             <%-- Page that displays the table of objects --%>
            <%@ include file="wizSelectTablespaces.jsp" %>
            
          </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
