<%--
  -- Page:        wizSelectedObjectsTable.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Selected Objects table for the review page
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   08/13/03 - Fix ADA issues 
  --   mnihalan   07/21/03 - Add type
  --   mnihalan   07/10/03 - Add columns
  --   mnihalan   04/15/03 - mnihalan_emdw_shrink
  --   mnihalan   04/01/03 - Initial creation
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="wizShrinkAdvTable">
  <uix:table name="tableList" 
                       alternateTextBinding="SCHEMA_NO_OBJECTS@stgMsg"
                       formSubmitted="true"
                       width="100%"
                       tableDataBinding="rowData@"
                       minValue="1"
                       valueBinding="startIndex@"
                       maxValueBinding="numRows@"
                       blockSize="10"
                       summaryBinding="SELECTED_OBJECTS_TABLE@stgMsg">
                
                 <%-- Table column Tablespace Name column --%>
                  <uix:column> 
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_TS@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_TS_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_TS_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                  <%-- Table column Schema column --%>
                  <uix:column renderedBinding="<%= ShrinkAdvConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_SCHEMA@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_SCHEMA_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_SCHEMA_ATTR%>"/>
                      </uix:contents>
                  </uix:column>
                  
                   <%-- Table column Segment Name --%>
                  <uix:column renderedBinding="<%= ShrinkAdvConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_OBJECT@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column Segment Type --%>
                  <uix:column renderedBinding="<%= ShrinkAdvConstants.RENDERED_ATTR %>">
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="RECOMMENDATIONS_PARTITION@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_PARTITION_NAME_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_PARTITION_NAME_ATTR %>"/>
                      </uix:contents>
                  </uix:column>

                   <%-- Table column Object Type--%>
                  <uix:column>
                      <uix:columnHeader>
                        <uix:sortableHeader textBinding="COLUMN_TYPE@stgMsg" sortableBinding="<%= ShrinkAdvConstants.RECOM_SORT_OBJECT_TYPE_ATTR %>"/>
                      </uix:columnHeader> 
                      <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:contents>
                          <uix:styledText textBinding="<%= ShrinkAdvConstants.RECOM_OBJECT_TYPE_ATTR %>"/>
                      </uix:contents>
                  </uix:column>
                  
                 </uix:table>
</uix:buildTree>