<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<%-- Message Bundle --%>
<uix:bundle name="stgMsg"
            class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destination="/console/database/shrinkAdv/shrinkAdv" copyParams="target,type,oname,sname,otype">
        <uix:formValue name="pageName" value="/database/shrinkAdv/wizShowSql"/>

        <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest" quickLinksShown="true">
            
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          
          <uix:location>
               <%@ include file="wizTrain.jsp" %>
          </uix:location>

          <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
               <uix:submitButton name="event"
                                 value="<%= JspConstants.SHOW_SQL_OK %>" 
                                 textBinding ="RETURN@stgMsg" />

            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
                  <uix:header textBinding="CREATE_TASK_AND_OBJECTS@stgMsg" >
                      <uix:contents>
                         <%-- START: TAB CONTENTS starts here --%>
                          <uix:stackLayout>
                            <db:sqlDisplay  sqlListBinding="createTaskAndObjectsSQLDesc@defaultBean@servletRequest"/>
                          </uix:stackLayout>
                      </uix:contents>
                  </uix:header>

                  <uix:spacer height="5"/>
                  
                  <uix:header textBinding="EXECUTE_TASK@stgMsg" >
                      <uix:contents>
                         <%-- START: TAB CONTENTS starts here --%>
                          <uix:stackLayout>
                            <db:sqlDisplay  sqlListBinding="analysisSQLDesc@defaultBean@servletRequest"/>
                          </uix:stackLayout>
                      </uix:contents>
                  </uix:header>
                  
          </uix:contents>

          
          </uix:pageLayout>
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
