<%--
  -- Page:        wizTaskScheduleInclude.jsp
  -- Controller:  oracle.sysman.db.util.shrinkAdv.ShrinkAdvController
  --
  -- Description: Page to select schema objects in brief mode
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihalan   07/21/04 - Change schedule include 
  --   mnihalan   11/11/03 - Add scheduling in maintenance window 
  --   mnihalan   09/16/03 - Fix schedule 
  --   mnihalan   09/12/03 - Change the schedule include 
  --   mnihalan   09/05/03 - Add Schedule Types 
  --   mnihalan   06/26/03 - mnihalan_shrinkad5_030626
  --   mnihalan   06/18/03 - Initital creation
  --%>

<%-- Imports --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.util.shrinkAdv.ShrinkAdvConstants" %>
<%@ page import="oracle.sysman.db.util.shrinkAdv.JspConstants" %>

<uix:buildTree nodeID="schedule">
      <uix:tip>
          <uix:contents>
                <uix:styledText textBinding="SCHEDULE_INSTR@stgMsg"
                                                  styleClass="OraMessageBoxParagraph"/>
          </uix:contents>
        </uix:tip>
             
              <uix:header textBinding="SCHED_TASK_INFO_HDR@stgMsg">
                <uix:labeledFieldLayout labelWidth="15%">
                  <uix:contents>
                    <uix:messagePrompt
                        labeledNodeId="jobName"
                        promptBinding="OPTIONS_TASK_NAME@stgMsg"
                        required="yes"/>
                    <uix:textInput
                        id="jobName"
                        name="<%= JspConstants.JOB_NAME %>"
                        textBinding="jobName@"
                        columns="60"/>
                    <uix:messagePrompt
                        labeledNodeId="jobDescription"
                        promptBinding="OPTIONS_TASK_DESC@stgMsg"/>
                    <uix:textInput
                        id="jobDescription"
                        name="jobDescription"
                        textBinding="jobDescription@"
                        columns="60"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:header>
              <uix:header textBinding="SCHED_OPTIONS_HEADER@stgMsg">
                      <jsp:include page="/database/instance/scheduler/scheduleType.jsp" />                
                    <uix:ref refID="scheduleType" />
              </uix:header>
              
</uix:buildTree>
    
