<%--
  -- Page:        accessMethods.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: 2nd step of SQL Access Advisor task creation wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --     misun     03/06/07 - fix SQL Access Advisor UI Exit Review bugs.
  --     misun     02/26/07 - fix SQL Access Advisor Executive Review bugs.
  --     misun     04/25/06 - Add new features: 17610 SQL Advisor - SAA 
  --                          Enhancement 11gR1. 
  --     mpawelko  03/29/05 - final 10.2 gui review changes 
  --     mpawelko  09/30/04 - make Advanced Options a Hide/Show header 
  --     mpawelko  09/08/04 - display warning about maintenance windows and mv's for 10g only
  --     glavash   03/03/03 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function isEvaluation()
{
    return (!((document.access.analysisScopeIndexesSelected.checked) ||
              (document.access.analysisScopeMaterializedViewsSelected.checked) ||
              (document.access.analysisScopePartitioningSelected.checked)));
}
function checkForEvaluation()
{
  bDisable = isEvaluation();
  document.access.analysisMode[0].disabled = bDisable;
  document.access.analysisMode[1].disabled = bDisable;

   if (document.access.workloadVolatilitySelected != null)
        checkForEvaluationOptions();  
}

function checkForEvalOnly()
{
  bDisable = document.access.executionTypeGUI[3].checked;
  document.access.analysisMode[0].disabled = bDisable;
  document.access.analysisMode[1].disabled = bDisable;

   if (document.access.workloadVolatilitySelected != null)
        checkForEvalOnlyOptions();
}
</script>         

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.util.sqlaccess.AccessParameterConstants" %>

<uix:renderingContext id="renderingContext">

<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<%@ include file="/oemTitle.jspf" %> 

    <%-- Include body tag so page is slightly indented from edge of window --%>
    <uix:body onLoadBinding="checkForEvaluation@objectBean@servletRequest">

<%-- HTML Form --%>
<db:form name="access"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest" 
         copyParams="target,type,advisoryCentralURL,dbPageNum" >
<uix:formValue name="pageName" value="/database/sqlaccess/accessMethods" />

<uix:pageLayout titleBinding = "METHOD_TITLE@AAMsgs">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

    <%-- Display wizard train and Logged in As --%>
    <uix:location>
        <uix:train selectedIndex="1">
            <db:link textBinding="STEP_WORKLOAD@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_METHODS@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="REVI_SCHED@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
            <db:link textBinding="STEP_REVIEW@AAMsgs"
                    copyParams="target,type,advisoryCentralURL,dbPageNum" />
        </uix:train>
    </uix:location>

    <uix:pageStatus>
       <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
     </uix:pageStatus>
     <%-- Follow page/wizard context information with a separator --%>
     <uix:separator/>

           <%-- Warning/Error display --%>
            <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
           <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

<uix:stackLayout>
 
<uix:header textBinding="METHOD_REC_TYPES@AAMsgs">
<uix:switcher childNameBinding="dbVersion@objectBean@servletRequest">
    <uix:case name="10g">
    <uix:stackLayout>
 
                <uix:styledText textBinding="METHOD_TEXT1@AAMsgs"
                            styleClass="OraFieldText" />

                <uix:tableLayout cellSpacing="5">
		  <uix:rowLayout>
		    <uix:cellFormat>
                      <uix:radioButton name="executionTypeGUI" 
                                       value="<%= AccessParameterConstants.INDEX_EXECUTION_TYPE%>" 
	                               textBinding="METHOD_INDEXES@AAMsgs"
                                       shortDescBinding="EXECUTION_TYPE_DESC@AAMsgs"  
                                       onClick='checkForEvalOnly()'	
                                       selectedValueBinding="executionTypeGUI@objectBean@servletRequest"/>
                    </uix:cellFormat>
		  </uix:rowLayout>
                  <uix:rowLayout>
		    <uix:cellFormat>
                      <uix:radioButton name="executionTypeGUI" 
                                       value="<%= AccessParameterConstants.MV_EXECUTION_TYPE%>" 
                                       textBinding="METHOD_MVS@AAMsgs" 
                                       shortDescBinding="EXECUTION_TYPE_DESC@AAMsgs"  
                                       onClick='checkForEvalOnly()'	
                                       selectedValueBinding="executionTypeGUI@objectBean@servletRequest"/>
                    </uix:cellFormat>
		  </uix:rowLayout>
                  <uix:rowLayout>
		    <uix:cellFormat>
                      <uix:radioButton name="executionTypeGUI" 
                                       value="<%= AccessParameterConstants.FULL%>" 
                                       textBinding="METHOD_BOTH@AAMsgs" 
                                       shortDescBinding="EXECUTION_TYPE_DESC@AAMsgs"  
                                       onClick='checkForEvalOnly()'	
                                       selectedValueBinding="executionTypeGUI@objectBean@servletRequest"/>
                    </uix:cellFormat>
		  </uix:rowLayout>
                 <uix:rowLayout>
<uix:cellFormat>
<uix:stackLayout>
                      <uix:radioButton name="executionTypeGUI" 
                                       value="<%= AccessParameterConstants.EVAL_EXECUTION_TYPE %>" 
                                       textBinding="EVALUATION_ONLY@AAMsgs" 
                                       shortDescBinding="EVALUATION_ONLY_DESC@AAMsgs" 
                                       onClick='checkForEvalOnly()'	
                                       selectedValueBinding="executionTypeGUI@objectBean@servletRequest"/>
<uix:flowLayout>
 <uix:spacer height="0" width="20" />
      <uix:styledText textBinding="EVAL_TIP@AAMsgs" styleClass="OraInlineInfoText" />
</uix:flowLayout>

</uix:stackLayout>

</uix:cellFormat>
		  </uix:rowLayout>
                </uix:tableLayout>
     <uix:spacer height="3"/>
     <%-- If 10g, warn about evaluating mv's in a maintenance window --%>
     <uix:tip renderedBinding="is10gR1@objectBean@servletRequest">
        <uix:styledText styleClass="OraTipText" 
                        textBinding="MV_WARNING@AAMsgs" />
     </uix:tip>
    
    </uix:stackLayout>
    </uix:case>
    
    <%-- for 11gR1, change the radio button into check boxes --%>
    <uix:case name="11gR1">
    <uix:stackLayout>  
        <%-- uix:styledText textBinding="METHOD_TEXT1_11G@AAMsgs"
                        styleClass="OraFieldText" /--%>
        <uix:rowLayout>
            <uix:checkBox name="analysisScopeIndexesSelected" 
                  textBinding="METHOD_INDEXES@AAMsgs" 
                  shortDescBinding="ANALYSIS_SCOPE_DESC@AAMsgs"
                  onClick='checkForEvaluation()'
                  styleClass="OraFieldText"
                  checkedBinding="analysisScopeIndexesSelected@objectBean@servletRequest" /> 
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:checkBox name="analysisScopeMaterializedViewsSelected" 
                  textBinding="METHOD_MVS@AAMsgs" 
                  shortDescBinding="ANALYSIS_SCOPE_DESC@AAMsgs"
                  onClick='checkForEvaluation()'
                  styleClass="OraFieldText"
                  checkedBinding="analysisScopeMaterializedViewsSelected@objectBean@servletRequest" /> 
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:checkBox name="analysisScopePartitioningSelected" 
                  textBinding="METHOD_PARTITIONING@AAMsgs" 
                  shortDescBinding="ANALYSIS_SCOPE_DESC@AAMsgs"
                  onClick='checkForEvaluation()'
                  styleClass="OraFieldText"
                  checkedBinding="analysisScopePartitioningSelected@objectBean@servletRequest" /> 
        </uix:rowLayout>    
    </uix:stackLayout>
    </uix:case>
</uix:switcher>
</uix:header>
  
<uix:header textBinding="OPT_MODE@AAMsgs" >
<uix:stackLayout>  
                <uix:styledText textBinding="OPT_MODE_TEXT@AAMsgs"
                            styleClass="OraFieldText" />
 <uix:spacer height="10"/>
  <uix:rowLayout>
  <uix:spacer width="5"/>
   <uix:radioButton name="analysisMode" 
                    value="<%= AccessParameterConstants.BRIEF_MODE%>" 
                    textBinding="BRIEF@AAMsgs" 
                    shortDescBinding="MODE_DESC@AAMsgs" 
                    selectedValueBinding="analysisMode@objectBean@servletRequest" />
   </uix:rowLayout>
   <uix:rowLayout>
   <uix:spacer height="0" width="25"/>
   <uix:styledText textBinding="OPT_BRIEF@AAMsgs" styleClass="OraInlineInfoText" />
   </uix:rowLayout>
   <uix:rowLayout>
  <uix:spacer width="5"/>
   <uix:radioButton name="analysisMode" 
                    value="<%= AccessParameterConstants.COMPREHENSIVE_MODE%>" 
                    textBinding="DETAILED@AAMsgs"
                    shortDescBinding="MODE_DESC@AAMsgs" 
                    selectedValueBinding="analysisMode@objectBean@servletRequest" />
   </uix:rowLayout>
    <uix:rowLayout>
   <uix:spacer  height="0" width="25"/>
   <uix:styledText textBinding="OPT_DETAILED@AAMsgs" styleClass="OraInlineInfoText" />
   </uix:rowLayout>
 </uix:stackLayout> 
</uix:header>

 <uix:hideShowHeader id="optionsHideShow"
                     textBinding="METHOD_ADV_OPT@AAMsgs"
                     disclosedBinding="optionsShowAdvanced@objectBean@servletRequest"
                     formName="access"
                     formSubmitted="true" >
   <%@ include file="options.jsp" %>
 </uix:hideShowHeader>
</uix:stackLayout>

    <uix:spacer height="10"/>               
    <uix:pageButtons>  
      <uix:pageButtonBar>
         <uix:submitButton textBinding="CANCEL@AAMsgs"
                           shortDescBinding="CANCEL@AAMsgs"
                     name = "event"
                     unvalidated="true"
                     value = "cancel" />
        <uix:navigationBar 
             maxValue="4" minValue="1" name="step" value="2" 
             destinationBinding="destination@objectBean@servletRequest"
             formSubmitted="true"
             formName="access" />
      </uix:pageButtonBar>
    </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
