<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        editConfirm.jsp
  -- Controller:  oracle.sysman.db.util.SqlAccessController
  --
  -- Description: Confirmation page when submitting an edited task
  --              warning that previous results will be deleted.
  --
  --  MODIFIED    (MM/DD/YY)
  --     sshastry  03/20/06 - 
  --     mpawelko  08/06/04 - fix browser title; use AAMsgs 
  --     mpawelko  01/29/04 - remove uixDBObjectBundle 
  --     mpawelko  11/16/03 - mpawelko_fix_3146804_part2 
  --     mpawelko  11/12/03 - created 
  --%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="AAMsgs" 
              class="oracle.sysman.db.rsc.sqla.SqlAccessMsg" />
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
 
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <db:form name="access" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,advisoryCentralURL,dbPageNum" >

         <uix:formValue name="pageName" value="/database/sqlaccess/editConfirm"/>
         <uix:pageLayout messageType="confirmation">
          
           <!-- Standard label, links, tabs, etc -->
<%--
           <%@ include file="/database/globalPopup.jspf" %>
--%>
           <uix:pageStatus>
             <uix:styledText styleClass="OraDataText" textBinding="RESUBMIT_WARN@AAMsgs" />  
           </uix:pageStatus>

           <uix:spacer height="10"/>

           <uix:styledText styleClass="OraInstructionText" textBinding="CONTINUE_QUESTION@AAMsgs" />  



          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@AAMsgs" 
                          shortDescBinding="NO@AAMsgs"
                      destination="javascript: history.back()" />
              <uix:submitButton textBinding="YES@AAMsgs" 
                                shortDescBinding="YES@AAMsgs"
                                name="event" 
                                value="doSubmitDBJob" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>            
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
